/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import com.google.common.collect.Multiset;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemEffectContext;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.network.ClientboundPacketTotemEffectMusic;
import pokefenn.totemic.network.NetworkHandler;

public final class StateTotemEffect
extends TotemState
implements TotemEffectContext {
    static final byte ID = 0;
    private int musicAmount = 0;

    StateTotemEffect(TotemBaseBlockEntity tile) {
        super(tile);
    }

    @Override
    public void tick() {
        Level level = this.tile.m_58904_();
        long gameTime = level.m_46467_();
        if (gameTime % (long)this.tile.getCommonTotemEffectInterval() == 0L) {
            for (Multiset.Entry entry : this.tile.getTotemEffects().entrySet()) {
                TotemEffect effect = (TotemEffect)entry.getElement();
                int repetition = entry.getCount();
                if (gameTime % (long)effect.getInterval() != 0L) continue;
                effect.effect(level, this.tile.m_58899_(), repetition, this);
            }
        }
        if (gameTime % 20L == 0L && this.musicAmount > 0) {
            int prevAnalogOut = this.getAnalogOutputSignal();
            int musicDrain = Mth.m_14045_((int)(this.musicAmount / 96), (int)10, (int)60);
            this.musicAmount = Math.max(this.musicAmount - musicDrain, 0);
            if (this.getAnalogOutputSignal() != prevAnalogOut) {
                this.tile.m_6596_();
            }
        }
        if (level.f_46443_ && gameTime % 40L == 0L) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        RandomSource rand = this.tile.m_58904_().m_213780_();
        Vec3 pos = this.getPosition();
        for (int i = 0; i < this.musicAmount * 8 / 7680; ++i) {
            float xoff = 2.0f * rand.m_188501_() - 1.0f;
            float zoff = 2.0f * rand.m_188501_() - 1.0f;
            this.tile.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, pos.f_82479_ + (double)xoff, pos.f_82480_, pos.f_82481_ + (double)zoff, 0.0, 0.5, 0.0);
        }
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        int previous = this.musicAmount;
        this.musicAmount = Math.min(previous + amount, 7680);
        if (this.musicAmount > previous) {
            Vec3 pos = Vec3.m_82512_((Vec3i)this.tile.m_58899_());
            NetworkHandler.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)64.0, (ResourceKey)this.tile.m_58904_().m_46472_())), (Object)new ClientboundPacketTotemEffectMusic(this.tile.m_58899_(), this.musicAmount));
            this.tile.m_6596_();
            return this.musicAmount == previous + amount ? MusicAcceptor.MusicResult.SUCCESS : MusicAcceptor.MusicResult.SUCCESS_SATURATED;
        }
        return MusicAcceptor.MusicResult.SATURATED;
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void addSelector(@Nonnull Entity entity, MusicInstrument instr) {
        StateSelection newState = new StateSelection(this.tile, this);
        newState.addSelector(entity, instr);
        this.tile.setTotemState(newState);
    }

    @Override
    public int getAnalogOutputSignal() {
        return this.musicAmount * 15 / 7680;
    }

    @Override
    public int getTotemEffectMusic() {
        return this.musicAmount;
    }

    public void setTotemEffectMusic(int amount) {
        this.musicAmount = amount;
    }

    @Override
    public int getPoleSize() {
        return this.tile.getPoleSize();
    }

    @Override
    public List<TotemCarving> getCarvingList() {
        return Collections.unmodifiableList(this.tile.getCarvingList());
    }

    @Override
    void resetTotemState() {
    }

    @Override
    byte getID() {
        return 0;
    }

    @Override
    void save(CompoundTag tag) {
        tag.m_128405_("TotemMusic", this.musicAmount);
    }

    @Override
    void load(CompoundTag tag) {
        this.musicAmount = tag.m_128451_("TotemMusic");
    }
}

