/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.util.MiscUtil;

public enum CleansingCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RANGE = 8;
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> conversions;
    private static final Predicate<Mob> hasWeakness;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (level.f_46443_) {
            return;
        }
        AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
        UUID uuid = context.getInitiatingPlayer().map(Entity::m_20148_).orElse(null);
        for (ZombieVillager zombieVillager : level.m_142425_((EntityTypeTest)EntityType.f_20530_, aabb, hasWeakness)) {
            zombieVillager.m_34383_(uuid, 1);
        }
        for (Mob mob2 : level.m_6443_(Mob.class, aabb, mob -> conversions.containsKey(mob.m_6095_()) && hasWeakness.test((Mob)mob))) {
            Mob converted = mob2.m_21406_(conversions.get(mob2.m_6095_()), true);
            if (converted == null) continue;
            converted.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123748_, level, converted.m_20191_().m_82399_(), 10, new Vec3(0.6, 0.5, 0.6), 1.0);
        }
    }

    @Override
    public boolean canSelect(Level level, BlockPos pos, Entity initiator) {
        if (level.m_6443_(Mob.class, TotemicEntityUtil.getAABBAround(pos, 8.0), mob -> (conversions.containsKey(mob.m_6095_()) || mob.m_6095_() == EntityType.f_20530_) && hasWeakness.test((Mob)mob)).isEmpty()) {
            initiator.m_213846_((Component)Component.m_237115_((String)"totemic.noZombifiedMonstersNearby"));
            return false;
        }
        return true;
    }

    static {
        conversions = Map.of(EntityType.f_20531_, EntityType.f_20511_, EntityType.f_20500_, EntityType.f_20456_, EntityType.f_20502_, EntityType.f_20457_);
        hasWeakness = m -> m.m_21023_(MobEffects.f_19613_);
    }
}

