/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.compat.kubejs.TotemicKubeJSPlugin;

public class CeremonyBuilder
extends BuilderBase<Ceremony> {
    public transient int musicNeeded = -1;
    public transient int maxStartupTime = -1;
    public transient MusicInstrument[] selectors;
    public transient EffectCallback effect;
    public transient int effectDuration = 0;

    public CeremonyBuilder(ResourceLocation id) {
        super(id);
    }

    public RegistryInfo<Ceremony> getRegistryType() {
        return TotemicKubeJSPlugin.CEREMONY;
    }

    public Ceremony createObject() {
        if (this.musicNeeded < 0) {
            throw new RuntimeException("musicNeeded not set for Ceremony '" + String.valueOf(this.id) + "'");
        }
        if (this.maxStartupTime < 0) {
            throw new RuntimeException("maxStartupTime not set for Ceremony '" + String.valueOf(this.id) + "'");
        }
        if (this.selectors == null) {
            throw new RuntimeException("selectors invalid or not set for Ceremony '" + String.valueOf(this.id) + "'");
        }
        if (this.effect == null) {
            throw new RuntimeException("effect not set for Ceremony '" + String.valueOf(this.id) + "'");
        }
        SimpleCeremonyInstance instance = new SimpleCeremonyInstance(this.effect, this.effectDuration);
        return new Ceremony(this.musicNeeded, this.maxStartupTime, () -> instance, this.selectors[0], this.selectors[1]);
    }

    @Info(value="Sets the amount of music needed to start the ceremony.")
    public CeremonyBuilder musicNeeded(int music) {
        this.musicNeeded = music;
        return this;
    }

    @Info(value="Sets the maximum time in ticks that the player may take to start the ceremony.\nThis value will be adjusted depending on the level's difficulty.\n")
    public CeremonyBuilder maxStartupTime(int time) {
        this.maxStartupTime = time;
        return this;
    }

    @Info(value="Sets the Ceremony's selecting instruments.")
    public CeremonyBuilder selectors(MusicInstrument ... selectors) {
        if (selectors.length < 2 || selectors.length > 2) {
            throw new IllegalArgumentException("Invalid number of Ceremony selectors: " + selectors.length);
        }
        this.selectors = selectors;
        return this;
    }

    @Info(value="Sets the Ceremony's effect.")
    public CeremonyBuilder effect(EffectCallback effect) {
        this.effect = Objects.requireNonNull(effect);
        return this;
    }

    @Info(value="Sets how many ticks the Ceremony effect will last.\n\nIf this is 0 (the default), the effect callback will be called exactly once on the server and client.\n")
    public CeremonyBuilder effectDuration(int duration) {
        this.effectDuration = duration;
        return this;
    }

    public String getTranslationKeyGroup() {
        return "totemic.ceremony";
    }

    @FunctionalInterface
    public static interface EffectCallback {
        public void effect(Level var1, BlockPos var2, CeremonyEffectContext var3);
    }

    private record SimpleCeremonyInstance(EffectCallback callback, int duration) implements CeremonyInstance
    {
        @Override
        public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
            this.callback.effect(level, pos, context);
        }

        @Override
        public int getEffectTime() {
            return this.duration;
        }
    }
}

