/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.level.LevelEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.event.CeremonyEvent;
import pokefenn.totemic.api.music.MusicInstrument;

public abstract class CeremonyKubeEvent
extends LevelEventJS {
    protected abstract CeremonyEvent getEvent();

    @Info(value="the level where the Ceremony is performed")
    public Level getLevel() {
        return (Level)this.getEvent().getLevel();
    }

    @Info(value="the position of the Totem Base where the Ceremony is performed")
    public BlockPos getPos() {
        return this.getEvent().getPos();
    }

    @Info(value="the Ceremony that is being performed")
    public Ceremony getCeremony() {
        return this.getEvent().getCeremony();
    }

    @Info(value="the CeremonyInstance of the performed Ceremony")
    public CeremonyInstance getCeremonyInstance() {
        return this.getEvent().getCeremonyInstance();
    }

    @Info(value="This event is fired every tick during the Ceremony effect phase. Will only be fired once if the Ceremony effect is instantaneous\n(i.e. `event.effectTime == 0`).\n\nWhen canceled, the Ceremony effect will not be applied. The Ceremony can be ended prematurely by using `event.context.endCeremony()`.\n")
    public static class EffectTick
    extends CeremonyKubeEvent {
        private final CeremonyEvent.EffectTick event;

        public EffectTick(CeremonyEvent.EffectTick event) {
            this.event = event;
        }

        @Override
        protected CeremonyEvent.EffectTick getEvent() {
            return this.event;
        }

        @Info(value="a CeremonyEffectContext providing details about the Ceremony's progress and allowing control over the Ceremony")
        public CeremonyEffectContext getContext() {
            return this.event.getContext();
        }

        @Info(value="the number of ticks that the Ceremony effect will last")
        public int getEffectTime() {
            return this.event.getEffectTime();
        }

        @Info(value="Changes the number of ticks that the Ceremony effect will last.\n\nKeep in mind that changing this to a non-zero value for instantaneous effects may produce unexpected results.\n")
        public void setEffectTime(int effectTime) {
            this.event.setEffectTime(effectTime);
        }
    }

    @Info(value="This event is fired when the player has successfully completed the ceremony startup.\n\nWhen canceled, the Ceremony is considered failed and the effect is not started (however, this behavior will probably change in the future).\nThis event is only fired on the server side, and it will not fire when the player uses the Creative Ceremony Cheat item.\n")
    public static class StartupSuccess
    extends CeremonyKubeEvent {
        private final CeremonyEvent.StartupSuccess event;

        public StartupSuccess(CeremonyEvent.StartupSuccess event) {
            this.event = event;
        }

        @Override
        protected CeremonyEvent.StartupSuccess getEvent() {
            return this.event;
        }

        @Info(value="a StartupContext providing details about the Ceremony's progress and allowing control over the Ceremony")
        public StartupContext getContext() {
            return this.event.getContext();
        }
    }

    @Info(value="This event is fired when the player was not successful in completing the ceremony startup because the time ran out.\n\nThis event is only fired on the server side.\n")
    public static class StartupFail
    extends CeremonyKubeEvent {
        private final CeremonyEvent.StartupFail event;

        public StartupFail(CeremonyEvent.StartupFail event) {
            this.event = event;
        }

        @Override
        protected CeremonyEvent.StartupFail getEvent() {
            return this.event;
        }

        @Info(value="a StartupContext providing details about the Ceremony's progress and allowing control over the Ceremony")
        public StartupContext getContext() {
            return this.event.getContext();
        }
    }

    @Info(value="This event is fired every tick during the Ceremony startup phase.\n\nWhen canceled, side effects of the startup (e.g. the damage dealt by the Sun Dance) will not be applied.\nThe startup phase can be skipped or aborted entirely by using `event.context.startCeremony()` or\n`event.context.failCeremony()`, respectively.\n")
    public static class StartupTick
    extends CeremonyKubeEvent {
        private final CeremonyEvent.StartupTick event;

        public StartupTick(CeremonyEvent.StartupTick event) {
            this.event = event;
        }

        @Override
        protected CeremonyEvent.StartupTick getEvent() {
            return this.event;
        }

        @Info(value="a StartupContext providing details about the Ceremony's progress and allowing control over the Ceremony")
        public StartupContext getContext() {
            return this.event.getContext();
        }
    }

    @Info(value="This event is fired when the required number of instruments for selecting a Ceremony has been played,\neven when the instruments don't match any Ceremony.\nIt allows changing the Ceremony that will be selected (if any), and skipping the Ceremony's selection check.\n\nThis events supports a Ceremony as target. To handle the case where no valid Ceremony was selected, omit the\ntarget and check if `event.ceremony` is null.\n\nWhen canceled (or `event.ceremony` is set to null), no Ceremony will be selected.\n")
    public static class Selection
    extends LevelEventJS {
        private final CeremonyEvent.Selection event;

        public Selection(CeremonyEvent.Selection event) {
            this.event = event;
        }

        @Info(value="the level where the Ceremony is performed")
        public Level getLevel() {
            return (Level)this.event.getLevel();
        }

        @Info(value="the position of the Totem Base where the Ceremony is performed")
        public BlockPos getPos() {
            return this.event.getPos();
        }

        @Info(value="the Entity who played the last selecting instrument for the Ceremony")
        public Entity getInitiator() {
            return this.event.getInitiator();
        }

        @Info(value="the list of selecting instruments")
        public List<MusicInstrument> getSelectors() {
            return this.event.getSelectors();
        }

        @Info(value="the Ceremony that is about to be selected. May be null if the selecting instruments don't match anyCeremony, or if the value was modified.")
        @Nullable
        public Ceremony getCeremony() {
            return this.event.getCeremony().orElse(null);
        }

        @Info(value="Modifies the Ceremony that will be selected. Pass null to select no Ceremony.")
        public void setCeremony(@Nullable Ceremony ceremony) {
            this.event.setCeremony(ceremony);
        }

        @Info(value="If true, the Ceremony's selection check (e.g. the Buffalo Dance checking for cows) will be skipped.")
        public boolean getSkipSelectionCheck() {
            return this.event.getSkipSelectionCheck();
        }

        @Info(value="When set to true, the Ceremony's selection check (e.g. the Buffalo Dance checking for cows) will be skipped.")
        public void setSkipSelectionCheck(boolean skipSelectionCheck) {
            this.event.setSkipSelectionCheck(skipSelectionCheck);
        }
    }
}

