/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.core.LevelKJS;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.function.Supplier;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegisterEvent;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.event.CeremonyEvent;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.compat.kubejs.CeremonyKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyCeremoniesKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyMusicInstrumentsKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyTotemCarvingsKubeEvent;
import pokefenn.totemic.compat.kubejs.TotemicKubeJSEvents;
import pokefenn.totemic.compat.kubejs.TotemicRegistryKubeEvent;

public class TotemicKubeEventHandler {
    public static void onRegister(RegisterEvent event) {
        event.register(RegistryAPI.MUSIC_INSTRUMENT_REGISTRY, registry -> TotemicKubeEventHandler.postTotemicRegistryEvent(TotemicKubeJSEvents.registerMusicInstruments, TotemicRegistryKubeEvent.MusicInstruments::new, registry));
        event.register(RegistryAPI.TOTEM_CARVING_REGISTRY, registry -> TotemicKubeEventHandler.postTotemicRegistryEvent(TotemicKubeJSEvents.registerTotemCarvings, TotemicRegistryKubeEvent.TotemCarvings::new, registry));
        event.register(RegistryAPI.CEREMONY_REGISTRY, registry -> TotemicKubeEventHandler.postTotemicRegistryEvent(TotemicKubeJSEvents.registerCeremonies, TotemicRegistryKubeEvent.Ceremonies::new, registry));
    }

    private static <T> void postTotemicRegistryEvent(EventHandler handler, Supplier<TotemicRegistryKubeEvent<? extends BuilderBase<T>>> eventSupplier, RegisterEvent.RegisterHelper<T> registry) {
        if (!handler.hasListeners()) {
            return;
        }
        TotemicRegistryKubeEvent<BuilderBase<T>> event = eventSupplier.get();
        handler.post(event);
        for (BuilderBase<T> builder : event.getBuilders()) {
            try {
                registry.register(builder.id, builder.createObject());
                ConsoleJS.STARTUP.info((Object)("Registered " + String.valueOf(builder.id) + " to " + String.valueOf(builder.getRegistryType())));
            }
            catch (Exception e) {
                ConsoleJS.STARTUP.error("Error registering " + String.valueOf(builder.id), (Throwable)e);
            }
        }
    }

    public static void postModificationEvents() {
        TotemicKubeJSEvents.modifyMusicInstruments.post((EventJS)new ModifyMusicInstrumentsKubeEvent());
        TotemicKubeJSEvents.modifyTotemCarvings.post((EventJS)new ModifyTotemCarvingsKubeEvent());
        TotemicKubeJSEvents.modifyCeremonies.post((EventJS)new ModifyCeremoniesKubeEvent());
    }

    @SubscribeEvent
    public static void onCeremonySelection(CeremonyEvent.Selection event) {
        EventResult result;
        Ceremony key = event.getCeremony().orElse(null);
        if (TotemicKubeJSEvents.ceremonySelection.hasListeners((Object)key) && (result = TotemicKubeJSEvents.ceremonySelection.post((EventJS)new CeremonyKubeEvent.Selection(event), (Object)key)).interruptFalse()) {
            event.setCeremony(null);
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupTick(CeremonyEvent.StartupTick event) {
        Ceremony key = event.getCeremony();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof LevelKJS) {
            EventResult result;
            LevelKJS level = (LevelKJS)levelAccessor;
            if (TotemicKubeJSEvents.ceremonyStartupTick.hasListeners((Object)key) && (result = TotemicKubeJSEvents.ceremonyStartupTick.post((ScriptTypeHolder)level, (Object)key, (EventJS)new CeremonyKubeEvent.StartupTick(event))).interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupFail(CeremonyEvent.StartupFail event) {
        Ceremony key = event.getCeremony();
        if (TotemicKubeJSEvents.ceremonyStartupFail.hasListeners((Object)key)) {
            TotemicKubeJSEvents.ceremonyStartupFail.post((EventJS)new CeremonyKubeEvent.StartupFail(event), (Object)key);
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupSuccess(CeremonyEvent.StartupSuccess event) {
        EventResult result;
        Ceremony key = event.getCeremony();
        if (TotemicKubeJSEvents.ceremonyStartupSuccess.hasListeners((Object)key) && (result = TotemicKubeJSEvents.ceremonyStartupSuccess.post((EventJS)new CeremonyKubeEvent.StartupSuccess(event), (Object)key)).interruptFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCeremonyEffectTick(CeremonyEvent.EffectTick event) {
        Ceremony key = event.getCeremony();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof LevelKJS) {
            EventResult result;
            LevelKJS level = (LevelKJS)levelAccessor;
            if (TotemicKubeJSEvents.ceremonyEffectTick.hasListeners((Object)key) && (result = TotemicKubeJSEvents.ceremonyEffectTick.post((ScriptTypeHolder)level, (Object)key, (EventJS)new CeremonyKubeEvent.EffectTick(event))).interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }
}

