/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.init;

import com.electronwill.nightconfig.core.Config;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicBlockTags;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.api.totem.PotionTotemEffect;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.ceremony.AnimalGrowthCeremony;
import pokefenn.totemic.ceremony.BaykokSummonCeremony;
import pokefenn.totemic.ceremony.BuffaloDanceCeremony;
import pokefenn.totemic.ceremony.CleansingCeremony;
import pokefenn.totemic.ceremony.DanseMacabreCeremony;
import pokefenn.totemic.ceremony.DepthsCeremony;
import pokefenn.totemic.ceremony.EagleDanceCeremony;
import pokefenn.totemic.ceremony.FertilityCeremony;
import pokefenn.totemic.ceremony.FluteInfusionCeremony;
import pokefenn.totemic.ceremony.SunDanceCeremony;
import pokefenn.totemic.ceremony.WarDanceCeremony;
import pokefenn.totemic.ceremony.WeatherCeremony;
import pokefenn.totemic.ceremony.ZaphkielWaltzCeremony;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.init.ModMobEffects;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.totem.OcelotTotemEffect;

public final class ModContent {
    public static final DeferredRegister<MusicInstrument> INSTRUMENTS = DeferredRegister.create(RegistryAPI.MUSIC_INSTRUMENT_REGISTRY, (String)"totemic");
    public static final RegistryObject<MusicInstrument> flute = INSTRUMENTS.register("flute", () -> new MusicInstrument(180, 3000).setItem((ItemLike)ModItems.flute.get()).setSound((Supplier<SoundEvent>)ModSounds.flute));
    public static final RegistryObject<MusicInstrument> drum = INSTRUMENTS.register("drum", () -> new MusicInstrument(240, 3300).setItem((ItemLike)ModBlocks.drum.get()).setSound((Supplier<SoundEvent>)ModSounds.drum));
    public static final RegistryObject<MusicInstrument> wind_chime = INSTRUMENTS.register("wind_chime", () -> new MusicInstrument(120, 1500).setItem((ItemLike)ModBlocks.wind_chime.get()).setSound((Supplier<SoundEvent>)ModSounds.wind_chime));
    public static final RegistryObject<MusicInstrument> jingle_dress = INSTRUMENTS.register("jingle_dress", () -> new MusicInstrument(180, 1500).setItem((ItemLike)ModItems.jingle_dress.get()));
    public static final RegistryObject<MusicInstrument> rattle = INSTRUMENTS.register("rattle", () -> new MusicInstrument(300, 3300).setItem((ItemLike)ModItems.rattle.get()).setSound((Supplier<SoundEvent>)ModSounds.rattle));
    public static final RegistryObject<MusicInstrument> eagle_bone_whistle = INSTRUMENTS.register("eagle_bone_whistle", () -> new MusicInstrument(360, 3600).setItem((ItemLike)ModItems.eagle_bone_whistle.get()).setSound((Supplier<SoundEvent>)ModSounds.eagle_bone_whistle));
    public static final DeferredRegister<TotemWoodType> WOOD_TYPES = DeferredRegister.create(RegistryAPI.WOOD_TYPE_REGISTRY, (String)"totemic");
    public static final RegistryObject<TotemWoodType> oak = WOOD_TYPES.register("oak", () -> new TotemWoodType(MapColor.f_283825_, MapColor.f_283819_, (TagKey<Block>)BlockTags.f_13108_));
    public static final RegistryObject<TotemWoodType> spruce = WOOD_TYPES.register("spruce", () -> new TotemWoodType(MapColor.f_283819_, MapColor.f_283748_, (TagKey<Block>)BlockTags.f_13112_));
    public static final RegistryObject<TotemWoodType> birch = WOOD_TYPES.register("birch", () -> new TotemWoodType(MapColor.f_283761_, MapColor.f_283942_, (TagKey<Block>)BlockTags.f_13109_));
    public static final RegistryObject<TotemWoodType> jungle = WOOD_TYPES.register("jungle", () -> new TotemWoodType(MapColor.f_283762_, MapColor.f_283819_, (TagKey<Block>)BlockTags.f_13111_));
    public static final RegistryObject<TotemWoodType> acacia = WOOD_TYPES.register("acacia", () -> new TotemWoodType(MapColor.f_283750_, MapColor.f_283947_, (TagKey<Block>)BlockTags.f_13110_));
    public static final RegistryObject<TotemWoodType> cherry = WOOD_TYPES.register("cherry", () -> new TotemWoodType(MapColor.f_283919_, MapColor.f_283861_, (TagKey<Block>)BlockTags.f_271212_));
    public static final RegistryObject<TotemWoodType> dark_oak = WOOD_TYPES.register("dark_oak", () -> new TotemWoodType(MapColor.f_283748_, MapColor.f_283748_, (TagKey<Block>)BlockTags.f_13107_));
    public static final RegistryObject<TotemWoodType> mangrove = WOOD_TYPES.register("mangrove", () -> new TotemWoodType(MapColor.f_283913_, MapColor.f_283819_, (TagKey<Block>)BlockTags.f_215840_));
    public static final RegistryObject<TotemWoodType> cedar = WOOD_TYPES.register("cedar", () -> new TotemWoodType(MapColor.f_283765_, MapColor.f_283750_, TotemicBlockTags.CEDAR_LOGS));
    public static final DeferredRegister<TotemCarving> CARVINGS = DeferredRegister.create(RegistryAPI.TOTEM_CARVING_REGISTRY, (String)"totemic");
    public static final RegistryObject<TotemCarving> none = CARVINGS.register("none", () -> TotemCarving.of(new TotemEffect[0]));
    public static final RegistryObject<TotemCarving> bat = CARVINGS.register("bat", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19591_)));
    public static final RegistryObject<TotemCarving> blaze = CARVINGS.register("blaze", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19607_)));
    public static final RegistryObject<TotemCarving> buffalo = CARVINGS.register("buffalo", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19598_)));
    public static final RegistryObject<TotemCarving> cow = CARVINGS.register("cow", () -> TotemCarving.of(new PotionTotemEffect(MobEffects.f_19606_), new PotionTotemEffect(MobEffects.f_19597_, false)));
    public static final RegistryObject<TotemCarving> enderman = CARVINGS.register("enderman", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19611_, false){

        @Override
        protected int getLingeringTime() {
            return 210;
        }
    }));
    public static final RegistryObject<TotemCarving> horse = CARVINGS.register("horse", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19596_)));
    public static final RegistryObject<TotemCarving> ocelot = CARVINGS.register("ocelot", () -> TotemCarving.of(new OcelotTotemEffect(), new PotionTotemEffect((MobEffect)ModMobEffects.ocelot.get(), false)));
    public static final RegistryObject<TotemCarving> pig = CARVINGS.register("pig", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19621_)));
    public static final RegistryObject<TotemCarving> rabbit = CARVINGS.register("rabbit", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19603_)));
    public static final RegistryObject<TotemCarving> spider = CARVINGS.register("spider", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((MobEffect)ModMobEffects.spider.get())));
    public static final RegistryObject<TotemCarving> squid = CARVINGS.register("squid", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19608_)));
    public static final RegistryObject<TotemCarving> wolf = CARVINGS.register("wolf", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.f_19600_)));
    public static final DeferredRegister<Ceremony> CEREMONIES = DeferredRegister.create(RegistryAPI.CEREMONY_REGISTRY, (String)"totemic");
    public static final RegistryObject<Ceremony> war_dance = CEREMONIES.register("war_dance", () -> new Ceremony(4500, 400, () -> WarDanceCeremony.INSTANCE, (Supplier<MusicInstrument>)drum, (Supplier<MusicInstrument>)drum));
    public static final RegistryObject<Ceremony> depths = CEREMONIES.register("depths", () -> new Ceremony(4500, 400, () -> DepthsCeremony.INSTANCE, (Supplier<MusicInstrument>)flute, (Supplier<MusicInstrument>)flute));
    public static final RegistryObject<Ceremony> fertility = CEREMONIES.register("fertility", () -> new Ceremony(5280, 460, () -> FertilityCeremony.INSTANCE, (Supplier<MusicInstrument>)flute, (Supplier<MusicInstrument>)drum));
    public static final RegistryObject<Ceremony> zaphkiel_waltz = CEREMONIES.register("zaphkiel_waltz", () -> new Ceremony(6720, 400, () -> ZaphkielWaltzCeremony.INSTANCE, (Supplier<MusicInstrument>)wind_chime, (Supplier<MusicInstrument>)flute));
    public static final RegistryObject<Ceremony> animal_growth = CEREMONIES.register("animal_growth", () -> new Ceremony(6900, 420, () -> AnimalGrowthCeremony.INSTANCE, (Supplier<MusicInstrument>)flute, (Supplier<MusicInstrument>)wind_chime));
    public static final RegistryObject<Ceremony> buffalo_dance = CEREMONIES.register("buffalo_dance", () -> new Ceremony(7380, 480, () -> BuffaloDanceCeremony.INSTANCE, (Supplier<MusicInstrument>)drum, (Supplier<MusicInstrument>)wind_chime));
    public static final RegistryObject<Ceremony> rain = CEREMONIES.register("rain", () -> new Ceremony(10980, 520, () -> WeatherCeremony.RAIN, (Supplier<MusicInstrument>)drum, (Supplier<MusicInstrument>)rattle));
    public static final RegistryObject<Ceremony> drought = CEREMONIES.register("drought", () -> new Ceremony(10980, 520, () -> WeatherCeremony.DROUGHT, (Supplier<MusicInstrument>)rattle, (Supplier<MusicInstrument>)drum));
    public static final RegistryObject<Ceremony> flute_infusion = CEREMONIES.register("flute_infusion", () -> new Ceremony(11340, 560, () -> FluteInfusionCeremony.INSTANCE, (Supplier<MusicInstrument>)flute, (Supplier<MusicInstrument>)rattle));
    public static final RegistryObject<Ceremony> eagle_dance = CEREMONIES.register("eagle_dance", () -> new Ceremony(11580, 500, () -> EagleDanceCeremony.INSTANCE, (Supplier<MusicInstrument>)rattle, (Supplier<MusicInstrument>)wind_chime));
    public static final RegistryObject<Ceremony> cleansing = CEREMONIES.register("cleansing", () -> new Ceremony(14700, 600, () -> CleansingCeremony.INSTANCE, (Supplier<MusicInstrument>)eagle_bone_whistle, (Supplier<MusicInstrument>)flute));
    public static final RegistryObject<Ceremony> sun_dance = CEREMONIES.register("sun_dance", () -> new Ceremony(14820, 620, () -> SunDanceCeremony.INSTANCE, (Supplier<MusicInstrument>)drum, (Supplier<MusicInstrument>)eagle_bone_whistle));
    public static final RegistryObject<Ceremony> danse_macabre = CEREMONIES.register("danse_macabre", () -> new Ceremony(14940, 640, () -> DanseMacabreCeremony.INSTANCE, (Supplier<MusicInstrument>)eagle_bone_whistle, (Supplier<MusicInstrument>)wind_chime));
    public static final RegistryObject<Ceremony> baykok_summon = CEREMONIES.register("baykok_summon", () -> new Ceremony(15060, 640, () -> BaykokSummonCeremony.INSTANCE, (Supplier<MusicInstrument>)wind_chime, (Supplier<MusicInstrument>)eagle_bone_whistle));

    public static void registerCustomWoodTypes(RegisterEvent event) {
        event.register(RegistryAPI.WOOD_TYPE_REGISTRY, reg -> {
            for (Config entry : (List)TotemicConfig.COMMON.customTotemWoodTypes.get()) {
                if (entry.isEmpty()) continue;
                String idStr = (String)entry.get("id");
                if (idStr == null) {
                    throw new IllegalArgumentException("Invalid custom Totem Wood Type: Missing entry 'id'. Please check your 'totemic-common.toml' config file.");
                }
                try {
                    String logsStr = (String)entry.get("logs");
                    if (logsStr == null) {
                        throw new IllegalArgumentException("Missing entry 'logs'");
                    }
                    if (!logsStr.startsWith("#")) {
                        throw new IllegalArgumentException("'logs' value must be a valid block tag key starting with '#'");
                    }
                    int woodColorIndex = entry.getIntOrElse("woodColor", MapColor.f_283825_.f_283805_);
                    int barkColorIndex = entry.getIntOrElse("barkColor", MapColor.f_283819_.f_283805_);
                    ResourceLocation id = new ResourceLocation(idStr);
                    TagKey logTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(logsStr.substring(1)));
                    MapColor woodColor = MapColor.m_284175_((int)woodColorIndex);
                    MapColor barkColor = MapColor.m_284175_((int)barkColorIndex);
                    reg.register(id, (Object)new TotemWoodType(woodColor, barkColor, (TagKey<Block>)logTagKey));
                    Totemic.logger.debug("Added custom Totem Wood Type with ID '" + String.valueOf(id) + "'");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid custom Totem Wood Type with ID '" + idStr + "': " + e.getLocalizedMessage() + "\nPlease check your 'totemic-common.toml' config file.", e);
                }
            }
        });
    }
}

