/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.util.BlockUtil;

public class MedicineBagItem
extends Item {
    public static final String TOTEM_TAG = "Totem";
    public static final String CHARGE_TAG = "Charge";
    public static final String OPEN_TAG = "Open";
    public static final int MAX_CHARGE = 4800;
    private static final LoadingCache<ItemStack, TotemCarving> carvingCache = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(stack -> Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(TOTEM_TAG, 8)).map(tag -> (TotemCarving)TotemicAPI.get().registry().totemCarvings().getValue(ResourceLocation.m_135820_((String)tag.m_128461_(TOTEM_TAG)))).orElseGet((Supplier<TotemCarving>)ModContent.none)));

    public MedicineBagItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void registerItemProperties() {
        ItemPropertyFunction func = (stack, level, entity, seed) -> MedicineBagItem.isOpen(stack) ? 1.0f : 0.0f;
        ResourceLocation name = Totemic.resloc("open");
        ItemProperties.register((Item)((Item)ModItems.medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
        ItemProperties.register((Item)((Item)ModItems.creative_medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
    }

    public static TotemCarving getCarving(ItemStack stack) {
        return (TotemCarving)carvingCache.getUnchecked((Object)stack);
    }

    public static int getCharge(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_(CHARGE_TAG) : 0;
    }

    public static boolean isOpen(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128471_(OPEN_TAG) : false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        TotemCarving carving;
        level.m_46473_().m_6180_("totemic.medicineBag");
        long gameTime = level.m_46467_();
        this.tryCharge(stack, level, gameTime, entity.m_20183_());
        if (MedicineBagItem.isOpen(stack) && (carving = MedicineBagItem.getCarving(stack)) != ModContent.none.get()) {
            this.applyEffects(stack, level, gameTime, entity, carving);
        }
        level.m_46473_().m_7238_();
    }

    protected void tryCharge(ItemStack stack, Level level, long gameTime, BlockPos pos) {
        TotemCarving carving;
        int charge;
        if (!level.f_46443_ && gameTime % 20L == 0L && (charge = MedicineBagItem.getCharge(stack)) < 4800 && (carving = MedicineBagItem.getCarving(stack)) != ModContent.none.get() && BlockUtil.getBlockEntitiesInRange((BlockEntityType)ModBlockEntities.totem_base.get(), level, pos, 6).anyMatch(tile -> tile.getTotemState() instanceof StateTotemEffect && tile.hasCarving(carving))) {
            int chargeAmount = 400;
            stack.m_41783_().m_128405_(CHARGE_TAG, Math.min(charge + chargeAmount, 4800));
        }
    }

    protected void applyEffects(ItemStack stack, Level level, long gameTime, Entity entity, TotemCarving carving) {
        int charge = MedicineBagItem.getCharge(stack);
        if (charge > 0) {
            for (TotemEffect effect : carving.getEffects()) {
                if (gameTime % (long)effect.getInterval() != 0L) continue;
                effect.medicineBagEffect((Player)entity, stack, charge);
            }
            if (!level.f_46443_ && gameTime % 80L == 0L) {
                stack.m_41783_().m_128405_(CHARGE_TAG, Math.max(charge - carving.getMedicineBagDrain(), 0));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return this.toggleOpen(pPlayer.m_21120_(pUsedHand), pLevel, pPlayer);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (!ctx.m_7078_()) {
            return this.toggleOpen(stack, ctx.m_43725_(), ctx.m_43723_()).m_19089_();
        }
        return this.trySetCarving(stack, ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43724_());
    }

    private InteractionResultHolder<ItemStack> toggleOpen(ItemStack stack, Level level, Player player) {
        if (MedicineBagItem.getCarving(stack) != ModContent.none.get()) {
            CompoundTag tag;
            tag.m_128379_(OPEN_TAG, !(tag = stack.m_41783_()).m_128471_(OPEN_TAG));
            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResult trySetCarving(ItemStack stack, Player player, Level level, BlockPos pos, InteractionHand hand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            if (((List)TotemicConfig.SERVER.medicineBagBlacklist.get()).contains(carving.getRegistryName().toString())) {
                player.m_5661_((Component)Component.m_237110_((String)"totemic.medicineBag.blacklisted", (Object[])new Object[]{carving.getDisplayName()}), true);
                return InteractionResult.FAIL;
            }
            if (!carving.supportsMedicineBag()) {
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237110_((String)"totemic.medicineBag.notPortable", (Object[])new Object[]{carving.getDisplayName()}), true);
                }
                return InteractionResult.FAIL;
            }
            ItemStack newStack = stack.m_41777_();
            carvingCache.invalidate((Object)stack);
            CompoundTag tag = newStack.m_41784_();
            tag.m_128359_(TOTEM_TAG, carving.getRegistryName().toString());
            if (!newStack.m_150930_((Item)ModItems.creative_medicine_bag.get())) {
                tag.m_128405_(CHARGE_TAG, 0);
            }
            player.m_21008_(hand, newStack);
            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{MedicineBagItem.getCarving(stack).getDisplayName()});
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String key = MedicineBagItem.getCarving(stack) != ModContent.none.get() ? (MedicineBagItem.getCharge(stack) > 0 ? (MedicineBagItem.isOpen(stack) ? "open" : "closed") : "empty") : "tooltip";
        tooltip.add((Component)Component.m_237115_((String)("totemic.medicineBag." + key)));
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237110_((String)"totemic.medicineBag.charge", (Object[])new Object[]{MedicineBagItem.getCharge(stack), 4800}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f * (float)MedicineBagItem.getCharge(pStack) / 4800.0f);
    }

    public int m_142159_(ItemStack pStack) {
        float f = (float)MedicineBagItem.getCharge(pStack) / 4800.0f;
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

