/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.TotemBaseBlock;
import pokefenn.totemic.block.totem.TotemPoleBlock;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;

public class TotemKnifeItem
extends Item {
    public static final String KNIFE_CARVING_KEY = "Carving";
    private static List<String> totemList;

    public TotemKnifeItem(Item.Properties props) {
        super(props);
    }

    private static MutableComponent getCarvingName(Optional<TotemCarving> carving) {
        return carving.map(TotemCarving::getDisplayName).orElseGet(() -> Component.m_237115_((String)"block.totemic.totem_base"));
    }

    public static Optional<TotemCarving> getCarving(ItemStack stack) {
        IForgeRegistry<TotemCarving> carvingRegistry = TotemicAPI.get().registry().totemCarvings();
        return Optional.ofNullable(stack.m_41783_()).map(tag -> tag.m_128461_(KNIFE_CARVING_KEY)).filter(str -> !str.isEmpty()).map(ResourceLocation::m_135820_).filter(arg_0 -> carvingRegistry.containsKey(arg_0)).map(arg_0 -> carvingRegistry.getValue(arg_0));
    }

    public static ItemStack changeIndex(ItemStack itemStack, boolean direction) {
        ItemStack stack;
        String key;
        int index;
        List<String> locTotemList = totemList;
        if (locTotemList == null) {
            totemList = locTotemList = TotemicAPI.get().registry().totemCarvings().getValues().stream().filter(e -> e != ModContent.none.get()).map(e -> e.getRegistryName().toString()).toList();
        }
        int n = index = (key = (stack = itemStack.m_41777_()).m_41784_().m_128461_(KNIFE_CARVING_KEY)).isEmpty() ? -1 : locTotemList.indexOf(key);
        if (index == -1) {
            index = direction ? 0 : locTotemList.size() - 1;
        } else if ((index += direction ? 1 : -1) >= locTotemList.size()) {
            index = -1;
        }
        String name = index == -1 ? "" : locTotemList.get(index);
        stack.m_41783_().m_128359_(KNIFE_CARVING_KEY, name);
        return stack;
    }

    public InteractionResult m_6225_(UseOnContext c) {
        Player player = c.m_43723_();
        if (player != null && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockState state = c.m_43725_().m_8055_(c.m_8083_());
        Optional<TotemWoodType> woodType = TotemKnifeItem.getWoodTypeForLog(state);
        if (woodType.isEmpty()) {
            return InteractionResult.FAIL;
        }
        Optional<TotemCarving> carving = TotemKnifeItem.getCarving(c.m_43722_());
        if (carving.isPresent()) {
            if (TotemKnifeItem.isCarvingDisabled(carving.get(), player)) {
                return InteractionResult.FAIL;
            }
            BlockState newState = ((TotemPoleBlock)((Object)ModBlocks.totem_pole.get())).m_5573_(new BlockPlaceContext(c));
            c.m_43725_().m_7731_(c.m_8083_(), newState, 11);
            c.m_43725_().m_141902_(c.m_8083_(), (BlockEntityType)ModBlockEntities.totem_pole.get()).ifPresent(pole -> pole.setAppearance((TotemWoodType)woodType.get(), (TotemCarving)carving.get()));
        } else {
            BlockState newState = ((TotemBaseBlock)((Object)ModBlocks.totem_base.get())).m_5573_(new BlockPlaceContext(c));
            c.m_43725_().m_7731_(c.m_8083_(), newState, 11);
            c.m_43725_().m_141902_(c.m_8083_(), (BlockEntityType)ModBlockEntities.totem_base.get()).ifPresent(base -> base.setWoodType((TotemWoodType)woodType.get()));
        }
        if (player != null) {
            c.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(c.m_43724_()));
        }
        c.m_43725_().m_5898_(player, 2001, c.m_8083_(), Block.m_49956_((BlockState)state));
        return InteractionResult.m_19078_((boolean)c.m_43725_().f_46443_);
    }

    private static Optional<TotemWoodType> getWoodTypeForLog(BlockState state) {
        return TotemicAPI.get().registry().woodTypes().getValues().stream().filter(wood -> state.m_204336_(wood.getLogTag())).findAny().or(() -> {
            if (state.m_204336_(BlockTags.f_13105_)) {
                return Optional.of((TotemWoodType)ModContent.oak.get());
            }
            return Optional.empty();
        });
    }

    private static boolean isCarvingDisabled(TotemCarving carving, @Nullable Player player) {
        if (((List)TotemicConfig.SERVER.disabledTotemCarvings.get()).contains(carving.getRegistryName().toString())) {
            if (player != null && player.m_9236_().m_5776_()) {
                player.m_213846_((Component)Component.m_237110_((String)"totemic.carvingDisabled", (Object[])new Object[]{carving.getDisplayName()}));
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19090_((Object)TotemKnifeItem.changeIndex(stack, true));
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[]{TotemKnifeItem.getCarvingName(TotemKnifeItem.getCarving(stack))});
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")));
    }
}

