/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.init.ModBlockEntities;

public record ClientboundPacketStartupMusic(BlockPos pos, MusicInstrument instrument, int amount) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeRegistryIdUnsafe(TotemicAPI.get().registry().instruments(), (Object)this.instrument);
        buf.m_130130_(this.amount);
    }

    public static ClientboundPacketStartupMusic decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        MusicInstrument instr = (MusicInstrument)buf.readRegistryIdUnsafe(TotemicAPI.get().registry().instruments());
        if (instr == null) {
            throw new RuntimeException("Invalid Music Instrument ID");
        }
        int amount = buf.m_130242_();
        return new ClientboundPacketStartupMusic(pos, instr, amount);
    }

    public static void handle(ClientboundPacketStartupMusic packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> Minecraft.m_91087_().f_91073_.m_141902_(packet.pos, (BlockEntityType)ModBlockEntities.totem_base.get()).ifPresent(tile -> {
            TotemState patt1595$temp = tile.getTotemState();
            if (patt1595$temp instanceof StateStartup) {
                StateStartup state = (StateStartup)patt1595$temp;
                state.setMusic(packet.instrument, packet.amount);
            }
        }));
        context.get().setPacketHandled(true);
    }
}

