/*
 * Decompiled with CFR 0.152.
 */
package n1luik.K_multi_threading.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import n1luik.K_multi_threading.install.Install;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;

public class ModLocator
extends AbstractJarFileModLocator {
    public final File file = this.loadModFile();
    private final List<File> libs = new ArrayList<File>();

    public ModLocator() {
        this.libs.add(this.file);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.deleteIfExists(this.file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    private File loadModFile() {
        try {
            InputStream resourceAsStream = Install.class.getResourceAsStream("/k_multi_threading-base.jar");
            byte[] b = resourceAsStream.readAllBytes();
            long hash = (long)Arrays.hashCode(b) & 0xFFFFFFFFL;
            File file = new File(System.getProperty("java.io.tmpdir"), hash + "_KAF.jar");
            try {
                Files.delete(file.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    if (Arrays.equals(fileInputStream.readAllBytes(), b)) {
                        fileInputStream.close();
                        return file;
                    }
                    fileInputStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                file = new File(System.getProperty("java.io.tmpdir"), "KAF_" + System.currentTimeMillis() + ".jar");
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(b);
            fileOutputStream.close();
            resourceAsStream.close();
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String name() {
        return "K_multi_threading.install";
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    public Stream<Path> scanCandidates() {
        return this.libs.stream().map(File::toPath);
    }
}

