package blocksmined;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2177;
import net.minecraft.class_2186;
import net.minecraft.class_2239;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_3222;
import net.minecraft.class_8646;
import net.minecraft.class_9013;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9025;
import net.minecraft.scoreboard.*;
import net.minecraft.server.MinecraftServer;
import java.util.Collection;
import java.util.Objects;

import static net.minecraft.class_2170.*;

public class BlocksMined implements ModInitializer {

	@Override
	public void onInitialize() {

		PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
			if (player.method_5682() != null)
				addScore(player.method_5682(), (class_3222) player, "blocksMined", "Blocks Mined");
		});

        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
       if (!world.field_9236 && player instanceof class_3222 serverPlayer && player.method_5682() != null) {
                class_1799 heldItem = player.method_5998(hand);
                if (heldItem.method_7909() instanceof class_1747 blockItem) {
                    addScore(player.method_5682(), serverPlayer, "blocksPlaced", "Blocks Placed");
                }
            }
            return class_1269.field_5811;
        });

        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(method_9247("blocks")
                    .requires(source -> source.method_9259(2))
                    .executes(context -> {
                        context.getSource().method_9226(() -> class_2561.method_43470("Usage: /blocks <mined|placed> <subcommand> [...]"), false);
                        return 1;
                    })
                    .then(method_9244("type", StringArgumentType.word())
                            .suggests((context, builder) -> builder.suggest("mined").suggest("placed").buildFuture())
                            .then(method_9247("color")
                                    .executes(ctx -> {
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Please enter a color"), false);
                                        return 1;
                                    })
                                    .then(method_9244("color", class_2177.method_9276())
                                            .executes(ctx -> {
                                                class_124 color = class_2177.method_9277(ctx, "color");
                                                String type = StringArgumentType.getString(ctx, "type");
                                                class_269 scoreboard = ctx.getSource().method_9211().method_3845();
                                                class_266 obj = scoreboard.method_1170(type.equals("mined") ? "blocksMined" : "blocksPlaced");

                                                class_9025 format = switch (color) {
                                                    case field_1061 -> class_9025.field_47567;
                                                    case field_1054 -> class_9025.field_47568;
                                                    default -> null;
                                                };

                                                if (format != null) {
                                                    if (obj != null) obj.method_55382(format);
                                                    ctx.getSource().method_9226(() -> class_2561.method_43470("Changed scoreboard color").method_27692(color), true);
                                                } else {
                                                    ctx.getSource().method_9226(() -> class_2561.method_43470("Only red and yellow are supported").method_27695(class_124.field_1061, class_124.field_1067), false);
                                                }
                                                return 1;
                                            })
                                    )
                            )
                            .then(method_9247("addscore")
                                    .executes(ctx -> {
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Please enter a player and amount"), false);
                                        return 1;
                                    })
                                    .then(method_9244("player", class_2186.method_9308())
                                            .then(method_9244("amount", IntegerArgumentType.integer())
                                                    .executes(ctx -> {
                                                        int amount = IntegerArgumentType.getInteger(ctx, "amount");
                                                        String type = StringArgumentType.getString(ctx, "type");
                                                        for (class_3222 player : class_2186.method_9312(ctx, "player")) {
                                                            addManualScore(ctx.getSource().method_9211(), player, type.equals("mined") ? "blocksMined" : "blocksPlaced", amount);
                                                        }
                                                        return 1;
                                                    })
                                            )
                                    )
                            )
                            .then(method_9247("removescore")
                                    .executes(ctx -> {
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Please enter a player and amount"), false);
                                        return 1;
                                    })
                                    .then(method_9244("player", class_2186.method_9308())
                                            .then(method_9244("amount", IntegerArgumentType.integer())
                                                    .executes(ctx -> {
                                                        int amount = IntegerArgumentType.getInteger(ctx, "amount");
                                                        String type = StringArgumentType.getString(ctx, "type");
                                                        for (class_3222 player : class_2186.method_9312(ctx, "player")) {
                                                            removeScore(ctx.getSource().method_9211(), player, type.equals("mined") ? "blocksMined" : "blocksPlaced", amount);
                                                        }
                                                        return 1;
                                                    })
                                            )
                                    )
                            )
                            .then(method_9247("reset")
                                    .executes(ctx -> {
                                        String type = StringArgumentType.getString(ctx, "type");
                                        resetObjective(ctx.getSource().method_9211(), type.equals("mined") ? "blocksMined" : "blocksPlaced",
                                                type.equals("mined") ? "Blocks Mined" : "Blocks Placed");
                                        return 1;
                                    })
                            )
                            .then(method_9247("display")
                                    .executes(ctx -> {
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Please enter a display position"), false);
                                        return 1;
                                    })
                                    .then(method_9244("position", class_2239.method_9468())
                                            .executes(ctx -> {
                                                class_8646 slot = class_2239.method_9465(ctx, "position");
                                                String type = StringArgumentType.getString(ctx, "type");
                                                displayObjective(ctx.getSource().method_9211(), type.equals("mined") ? "blocksMined" : "blocksPlaced", slot);
                                                return 1;
                                            })
                                    )
                            )
                            .then(method_9247("name")
                                    .executes(ctx -> {
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Please enter a name"), false);
                                        return 1;
                                    })
                                    .then(method_9244("name", StringArgumentType.string())
                                            .executes(ctx -> {
                                                String name = StringArgumentType.getString(ctx, "name");
                                                String type = StringArgumentType.getString(ctx, "type");
                                                class_269 scoreboard = ctx.getSource().method_9211().method_3845();
                                                class_266 obj = scoreboard.method_1170(type.equals("mined") ? "blocksMined" : "blocksPlaced");
                                                if (obj != null) obj.method_1121(class_2561.method_30163(name));
                                                return 1;
                                            })
                                    )
                            )
                    )
            );
        });

    }

	public static void addScore(MinecraftServer server, class_3222 player, String name, String title) {
        class_269 scoreboard = server.method_3845();
		class_266 objective = scoreboard.method_1170(name);

		if (objective == null) {
			objective = scoreboard.method_1168(
					name,
					class_274.field_1468,
					class_2561.method_43470(title),
					class_274.class_275.field_1472,
					true,
					class_9025.field_47567
			);
			scoreboard.method_1158(class_8646.field_45157, objective);
		}

		class_9014 blocksMinedScore = scoreboard.method_55425(player, objective, true);
		class_9013 currentScore = scoreboard.method_55430(class_9015.method_55422(player.method_5820()), objective);
		if (currentScore != null)
			blocksMinedScore.method_55410(currentScore.method_55397() + 1);
		else
			blocksMinedScore.method_55410(1);
	}

    public static void addManualScore(MinecraftServer server, class_3222 player, String objectiveName, int amount) {
        class_269 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective == null) {
            objective = scoreboard.method_1168(objectiveName, class_274.field_1468, class_2561.method_43470(objectiveName), class_274.class_275.field_1472, true, class_9025.field_47567);
        }
        class_9014 score = scoreboard.method_55425(player, objective, true);
        class_9013 current = scoreboard.method_55430(class_9015.method_55422(player.method_5820()), objective);
        score.method_55410((current != null ? current.method_55397() : 0) + amount);
    }

    public static void removeScore(MinecraftServer server, class_3222 player, String objectiveName, int amount) {
        class_269 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective == null) return;
        class_9014 score = scoreboard.method_55425(player, objective, true);
        class_9013 current = scoreboard.method_55430(class_9015.method_55422(player.method_5820()), objective);
        if (current != null) {
            score.method_55410(Math.max(0, current.method_55397() - amount));
        }
    }

    public static void resetObjective(MinecraftServer server, String objectiveName, String displayName) {
        class_269 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) scoreboard.method_1194(objective);
        scoreboard.method_1168(objectiveName, class_274.field_1468, class_2561.method_43470(displayName), class_274.class_275.field_1472, true, class_9025.field_47567);
    }

    public static void displayObjective(MinecraftServer server, String objectiveName, class_8646 slot) {
        class_269 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) scoreboard.method_1158(slot, objective);
    }

}