/*
 * Decompiled with CFR 0.152.
 */
package blocksmined;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2186;
import net.minecraft.class_2239;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_8646;
import net.minecraft.class_9013;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9025;
import net.minecraft.server.MinecraftServer;

public class BlocksMined
implements ModInitializer {
    public void onInitialize() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (player.method_5682() != null) {
                BlocksMined.addScore(player.method_5682(), (class_3222)player, "blocksMined", "Blocks Mined");
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            if (!world.field_9236 && player instanceof class_3222) {
                class_1799 heldItem;
                class_1792 patt0$temp;
                class_3222 serverPlayer = (class_3222)player;
                if (player.method_5682() != null && (patt0$temp = (heldItem = player.method_5998(hand)).method_7909()) instanceof class_1747) {
                    class_1747 blockItem = (class_1747)patt0$temp;
                    BlocksMined.addScore(player.method_5682(), serverPlayer, "blocksPlaced", "Blocks Placed");
                }
            }
            return class_1269.field_5811;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blocks").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Usage: /blocks <mined|placed> <subcommand> [...]"), false);
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> builder.suggest("mined").suggest("placed").buildFuture()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"color").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Please enter a color"), false);
            return 1;
        })).then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(ctx -> {
            class_9025 format;
            class_124 color = class_2177.method_9277((CommandContext)ctx, (String)"color");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            class_2995 scoreboard = ((class_2168)ctx.getSource()).method_9211().method_3845();
            class_266 obj = scoreboard.method_1170(type.equals("mined") ? "blocksMined" : "blocksPlaced");
            switch (color) {
                case field_1061: {
                    class_9025 class_90252 = class_9025.field_47567;
                    break;
                }
                case field_1054: {
                    class_9025 class_90252 = class_9025.field_47568;
                    break;
                }
                default: {
                    class_9025 class_90252 = format = null;
                }
            }
            if (format != null) {
                if (obj != null) {
                    obj.method_55382((class_9022)format);
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Changed scoreboard color").method_27692(color), true);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Only red and yellow are supported").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"addscore").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Please enter a player and amount"), false);
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            for (class_3222 player : class_2186.method_9312((CommandContext)ctx, (String)"player")) {
                BlocksMined.addManualScore(((class_2168)ctx.getSource()).method_9211(), player, type.equals("mined") ? "blocksMined" : "blocksPlaced", amount);
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removescore").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Please enter a player and amount"), false);
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            for (class_3222 player : class_2186.method_9312((CommandContext)ctx, (String)"player")) {
                BlocksMined.removeScore(((class_2168)ctx.getSource()).method_9211(), player, type.equals("mined") ? "blocksMined" : "blocksPlaced", amount);
            }
            return 1;
        }))))).then(class_2170.method_9247((String)"reset").executes(ctx -> {
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            BlocksMined.resetObjective(((class_2168)ctx.getSource()).method_9211(), type.equals("mined") ? "blocksMined" : "blocksPlaced", type.equals("mined") ? "Blocks Mined" : "Blocks Placed");
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"display").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Please enter a display position"), false);
            return 1;
        })).then(class_2170.method_9244((String)"position", (ArgumentType)class_2239.method_9468()).executes(ctx -> {
            class_8646 slot = class_2239.method_9465((CommandContext)ctx, (String)"position");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            BlocksMined.displayObjective(((class_2168)ctx.getSource()).method_9211(), type.equals("mined") ? "blocksMined" : "blocksPlaced", slot);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"name").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Please enter a name"), false);
            return 1;
        })).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            class_2995 scoreboard = ((class_2168)ctx.getSource()).method_9211().method_3845();
            class_266 obj = scoreboard.method_1170(type.equals("mined") ? "blocksMined" : "blocksPlaced");
            if (obj != null) {
                obj.method_1121(class_2561.method_30163((String)name));
            }
            return 1;
        }))))));
    }

    public static void addScore(MinecraftServer server, class_3222 player, String name, String title) {
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(name);
        if (objective == null) {
            objective = scoreboard.method_1168(name, class_274.field_1468, (class_2561)class_2561.method_43470((String)title), class_274.class_275.field_1472, true, (class_9022)class_9025.field_47567);
            scoreboard.method_1158(class_8646.field_45157, objective);
        }
        class_9014 blocksMinedScore = scoreboard.method_55425((class_9015)player, objective, true);
        class_9013 currentScore = scoreboard.method_55430(class_9015.method_55422((String)player.method_5820()), objective);
        if (currentScore != null) {
            blocksMinedScore.method_55410(currentScore.method_55397() + 1);
        } else {
            blocksMinedScore.method_55410(1);
        }
    }

    public static void addManualScore(MinecraftServer server, class_3222 player, String objectiveName, int amount) {
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective == null) {
            objective = scoreboard.method_1168(objectiveName, class_274.field_1468, (class_2561)class_2561.method_43470((String)objectiveName), class_274.class_275.field_1472, true, (class_9022)class_9025.field_47567);
        }
        class_9014 score = scoreboard.method_55425((class_9015)player, objective, true);
        class_9013 current = scoreboard.method_55430(class_9015.method_55422((String)player.method_5820()), objective);
        score.method_55410((current != null ? current.method_55397() : 0) + amount);
    }

    public static void removeScore(MinecraftServer server, class_3222 player, String objectiveName, int amount) {
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective == null) {
            return;
        }
        class_9014 score = scoreboard.method_55425((class_9015)player, objective, true);
        class_9013 current = scoreboard.method_55430(class_9015.method_55422((String)player.method_5820()), objective);
        if (current != null) {
            score.method_55410(Math.max(0, current.method_55397() - amount));
        }
    }

    public static void resetObjective(MinecraftServer server, String objectiveName, String displayName) {
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) {
            scoreboard.method_1194(objective);
        }
        scoreboard.method_1168(objectiveName, class_274.field_1468, (class_2561)class_2561.method_43470((String)displayName), class_274.class_275.field_1472, true, (class_9022)class_9025.field_47567);
    }

    public static void displayObjective(MinecraftServer server, String objectiveName, class_8646 slot) {
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) {
            scoreboard.method_1158(slot, objective);
        }
    }
}

