/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geodedimension.network;

import java.util.function.Supplier;
import net.mcreator.geodedimension.GeodeManiaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeodeManiaModVariables {
    public static double ameSledge_x = 0.0;
    public static double ameSledge_y = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GeodeManiaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        GeodeManiaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.notmyself = message.data.notmyself;
                    variables.monocle_success = message.data.monocle_success;
                    variables.electrifiedHelm = message.data.electrifiedHelm;
                    variables.electrifiedChest = message.data.electrifiedChest;
                    variables.electrifiedLegs = message.data.electrifiedLegs;
                    variables.electrifiedFeet = message.data.electrifiedFeet;
                    variables.insulationHelm = message.data.insulationHelm;
                    variables.insulationChest = message.data.insulationChest;
                    variables.insulationLegs = message.data.insulationLegs;
                    variables.insulationFeet = message.data.insulationFeet;
                    variables.echoArmorPieceTotal = message.data.echoArmorPieceTotal;
                    variables.isInfernoable = message.data.isInfernoable;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double notmyself = 0.0;
        public boolean monocle_success = false;
        public double electrifiedHelm = 0.0;
        public double electrifiedChest = 0.0;
        public double electrifiedLegs = 0.0;
        public double electrifiedFeet = 0.0;
        public double insulationHelm = 0.0;
        public double insulationChest = 0.0;
        public double insulationLegs = 0.0;
        public double insulationFeet = 0.0;
        public double echoArmorPieceTotal = 0.0;
        public double isInfernoable = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("notmyself", this.notmyself);
            nbt.m_128379_("monocle_success", this.monocle_success);
            nbt.m_128347_("electrifiedHelm", this.electrifiedHelm);
            nbt.m_128347_("electrifiedChest", this.electrifiedChest);
            nbt.m_128347_("electrifiedLegs", this.electrifiedLegs);
            nbt.m_128347_("electrifiedFeet", this.electrifiedFeet);
            nbt.m_128347_("insulationHelm", this.insulationHelm);
            nbt.m_128347_("insulationChest", this.insulationChest);
            nbt.m_128347_("insulationLegs", this.insulationLegs);
            nbt.m_128347_("insulationFeet", this.insulationFeet);
            nbt.m_128347_("echoArmorPieceTotal", this.echoArmorPieceTotal);
            nbt.m_128347_("isInfernoable", this.isInfernoable);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.notmyself = nbt.m_128459_("notmyself");
            this.monocle_success = nbt.m_128471_("monocle_success");
            this.electrifiedHelm = nbt.m_128459_("electrifiedHelm");
            this.electrifiedChest = nbt.m_128459_("electrifiedChest");
            this.electrifiedLegs = nbt.m_128459_("electrifiedLegs");
            this.electrifiedFeet = nbt.m_128459_("electrifiedFeet");
            this.insulationHelm = nbt.m_128459_("insulationHelm");
            this.insulationChest = nbt.m_128459_("insulationChest");
            this.insulationLegs = nbt.m_128459_("insulationLegs");
            this.insulationFeet = nbt.m_128459_("insulationFeet");
            this.echoArmorPieceTotal = nbt.m_128459_("echoArmorPieceTotal");
            this.isInfernoable = nbt.m_128459_("isInfernoable");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("geode_mania", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "geode_mania_mapvars";
        public double chorus_teleport_check = 0.0;
        public double chorus_spawn_check = 0.0;
        public double ameSledge_z = 0.0;
        public double reactorItemSubType = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.chorus_teleport_check = nbt.m_128459_("chorus_teleport_check");
            this.chorus_spawn_check = nbt.m_128459_("chorus_spawn_check");
            this.ameSledge_z = nbt.m_128459_("ameSledge_z");
            this.reactorItemSubType = nbt.m_128459_("reactorItemSubType");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("chorus_teleport_check", this.chorus_teleport_check);
            nbt.m_128347_("chorus_spawn_check", this.chorus_spawn_check);
            nbt.m_128347_("ameSledge_z", this.ameSledge_z);
            nbt.m_128347_("reactorItemSubType", this.reactorItemSubType);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "geode_mania_worldvars";
        public boolean GeodeReactorActive = false;
        public double reactorItemRarity = 0.0;
        public double reactorUniqueItems = 0.0;
        public double reactorItemType = 0.0;
        public boolean sculkingInWorld = false;
        public boolean wardenKingSummon = false;
        public double echoDetectorValue = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.GeodeReactorActive = nbt.m_128471_("GeodeReactorActive");
            this.reactorItemRarity = nbt.m_128459_("reactorItemRarity");
            this.reactorUniqueItems = nbt.m_128459_("reactorUniqueItems");
            this.reactorItemType = nbt.m_128459_("reactorItemType");
            this.sculkingInWorld = nbt.m_128471_("sculkingInWorld");
            this.wardenKingSummon = nbt.m_128471_("wardenKingSummon");
            this.echoDetectorValue = nbt.m_128459_("echoDetectorValue");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("GeodeReactorActive", this.GeodeReactorActive);
            nbt.m_128347_("reactorItemRarity", this.reactorItemRarity);
            nbt.m_128347_("reactorUniqueItems", this.reactorUniqueItems);
            nbt.m_128347_("reactorItemType", this.reactorItemType);
            nbt.m_128379_("sculkingInWorld", this.sculkingInWorld);
            nbt.m_128379_("wardenKingSummon", this.wardenKingSummon);
            nbt.m_128347_("echoDetectorValue", this.echoDetectorValue);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.notmyself = original.notmyself;
            clone.monocle_success = original.monocle_success;
            clone.electrifiedHelm = original.electrifiedHelm;
            clone.electrifiedChest = original.electrifiedChest;
            clone.electrifiedLegs = original.electrifiedLegs;
            clone.electrifiedFeet = original.electrifiedFeet;
            clone.insulationHelm = original.insulationHelm;
            clone.insulationChest = original.insulationChest;
            clone.insulationLegs = original.insulationLegs;
            clone.insulationFeet = original.insulationFeet;
            clone.echoArmorPieceTotal = original.echoArmorPieceTotal;
            clone.isInfernoable = original.isInfernoable;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                GeodeManiaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

