/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geodedimension.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.geodedimension.GeodeManiaMod;
import net.mcreator.geodedimension.procedures.EBPBigbottleToBottleProcedure;
import net.mcreator.geodedimension.procedures.EBPBlocksToLapisProcedure;
import net.mcreator.geodedimension.procedures.EBPBottleToBigbottleProcedure;
import net.mcreator.geodedimension.procedures.EBPFillFlaskLProcedure;
import net.mcreator.geodedimension.procedures.EBPFillFlaskRProcedure;
import net.mcreator.geodedimension.procedures.EBPFillTankLProcedure;
import net.mcreator.geodedimension.procedures.EBPFillTankRProcedure;
import net.mcreator.geodedimension.procedures.EBPLapisToBlocksProcedure;
import net.mcreator.geodedimension.procedures.PortableEnchantProcedureProcedure;
import net.mcreator.geodedimension.world.inventory.SculkExpandedBookPouchGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SculkExpandedBookPouchGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SculkExpandedBookPouchGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SculkExpandedBookPouchGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SculkExpandedBookPouchGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SculkExpandedBookPouchGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SculkExpandedBookPouchGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SculkExpandedBookPouchGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            EBPBottleToBigbottleProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            EBPBigbottleToBottleProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            EBPLapisToBlocksProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            EBPBlocksToLapisProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            EBPFillFlaskLProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            EBPFillFlaskRProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            EBPFillTankLProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            EBPFillTankRProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            PortableEnchantProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeodeManiaMod.addNetworkMessage(SculkExpandedBookPouchGUIButtonMessage.class, SculkExpandedBookPouchGUIButtonMessage::buffer, SculkExpandedBookPouchGUIButtonMessage::new, SculkExpandedBookPouchGUIButtonMessage::handler);
    }
}

