/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geodedimension.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.geodedimension.GeodeManiaMod;
import net.mcreator.geodedimension.procedures.BreakAmberliteBlockProcedure;
import net.mcreator.geodedimension.procedures.BreakAmberliteGemProcedure;
import net.mcreator.geodedimension.procedures.BreakAmberliteHypercondensedProcedure;
import net.mcreator.geodedimension.procedures.CyanSpectrumShiftProcedure;
import net.mcreator.geodedimension.procedures.GreenSpectrumShiftProcedure;
import net.mcreator.geodedimension.procedures.MagentaSpectrumShiftProcedure;
import net.mcreator.geodedimension.procedures.OrangeSpectrumShiftProcedure;
import net.mcreator.geodedimension.procedures.RedSpectrumShiftProcedure;
import net.mcreator.geodedimension.procedures.ReformAmberliteBlockProcedure;
import net.mcreator.geodedimension.procedures.ReformAmberliteGemProcedure;
import net.mcreator.geodedimension.procedures.ReformAmberliteHypercondensedProcedure;
import net.mcreator.geodedimension.procedures.YellowSpectrumShiftProcedure;
import net.mcreator.geodedimension.world.inventory.ShiftSpectrumMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ShiftSpectrumButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ShiftSpectrumButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ShiftSpectrumButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ShiftSpectrumButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ShiftSpectrumButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ShiftSpectrumButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ShiftSpectrumMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RedSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            OrangeSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            YellowSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GreenSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            CyanSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            MagentaSpectrumShiftProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ReformAmberliteHypercondensedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            BreakAmberliteHypercondensedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            ReformAmberliteBlockProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            BreakAmberliteBlockProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            ReformAmberliteGemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            BreakAmberliteGemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeodeManiaMod.addNetworkMessage(ShiftSpectrumButtonMessage.class, ShiftSpectrumButtonMessage::buffer, ShiftSpectrumButtonMessage::new, ShiftSpectrumButtonMessage::handler);
    }
}

