/*
 * Decompiled with CFR 0.152.
 */
package de.jottyfan.quickiemod.event;

import de.jottyfan.quickiemod.Quickiemod;
import de.jottyfan.quickiemod.item.HarvestRange;
import de.jottyfan.quickiemod.item.ModItems;
import de.jottyfan.quickiemod.item.ToolRangeable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class EventBlockBreak {
    public boolean doBreakBlock(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 playerEntity, class_2248 oldBlock) {
        class_1799 mainHandItemStack = playerEntity.method_6118(class_1304.field_6173);
        if (mainHandItemStack != null) {
            class_1792 item = mainHandItemStack.method_7909();
            if (item instanceof ToolRangeable) {
                ToolRangeable tool = (ToolRangeable)item;
                int handled = this.handleRangeableTools(tool, mainHandItemStack, world, oldBlock, blockPos, playerEntity);
                if (handled >= 255) {
                    world.method_8649((class_1297)new class_1303(world, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), handled / 255));
                }
                return handled > 0;
            }
            return false;
        }
        return false;
    }

    private int handleRangeableTools(ToolRangeable tool, class_1799 itemStack, class_1937 world, class_2248 currentBlock, class_2338 pos, class_1657 player) {
        List<class_2248> validBlocks = tool.getBlockList(currentBlock);
        HarvestRange range = tool.getRange(itemStack);
        if (tool instanceof class_1792) {
            class_1792 toolItem = (class_1792)tool;
            ArrayList<String> visitedBlocks = new ArrayList<String>();
            if (ModItems.TOOL_SPEEDPOWDERAXE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.UPWARDS, player, true);
            }
            if (ModItems.TOOL_SPEEDPOWDERPICKAXE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            if (ModItems.TOOL_SPEEDPOWDERSHOVEL.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            if (ModItems.TOOL_SPEEDPOWDERHOE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            if (ModItems.TOOL_QUICKIEPOWDERAXE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.UPWARDS, player, true);
            }
            if (ModItems.TOOL_QUICKIEPOWDERPICKAXE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            if (ModItems.TOOL_QUICKIEPOWDERSHOVEL.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            if (ModItems.TOOL_QUICKIEPOWDERHOE.method_63680().equals((Object)toolItem.method_63680())) {
                return this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos, tool, range, BlockBreakDirection.ALL, player, false);
            }
            return 0;
        }
        Quickiemod.LOGGER.warn("using a tool that is not an item - no rangeable operations are possible.");
        return 0;
    }

    private int breakBlockRecursive(List<String> visitedBlocks, class_1937 world, List<class_2248> validBlocks, class_2338 pos, ToolRangeable tool, HarvestRange range, BlockBreakDirection blockBreakDirection, class_1657 player, boolean breakLeaves) {
        class_2248 currentBlock;
        if (visitedBlocks.contains(pos.toString())) {
            return 0;
        }
        if (validBlocks == null) {
            return 0;
        }
        visitedBlocks.add(pos.toString());
        Integer affected = 0;
        class_2680 blockState = world.method_8320(pos);
        if (tool.canBreakNeighbors(blockState) && validBlocks.contains(currentBlock = blockState.method_26204())) {
            class_2248.method_9497((class_2680)blockState, (class_1937)world, (class_2338)pos);
            affected = affected + 1;
            world.method_8501(pos, class_2246.field_10124.method_9564());
            if (range == null || range.getxRange() > 1 || range.getyRange() > 1 || range.getzRange() > 1) {
                HarvestRange nextRadius = range == null ? null : range.addXYZ(-1);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10095(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10095().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10095().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10072(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10072().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10072().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10095(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10095().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10095().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10072().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10072().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10084().method_10072(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                if (BlockBreakDirection.ALL.equals((Object)blockBreakDirection)) {
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10095(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10072(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10095().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10095().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10072().method_10078(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                    affected = affected + this.breakBlockRecursive(visitedBlocks, world, validBlocks, pos.method_10074().method_10072().method_10067(), tool, nextRadius, blockBreakDirection, player, breakLeaves);
                }
            }
        }
        return affected;
    }

    private static enum BlockBreakDirection {
        UPWARDS,
        ALL;

    }
}

