/*
 * Decompiled with CFR 0.152.
 */
package de.jottyfan.quickiemod.blockentity;

import de.jottyfan.quickiemod.Quickiemod;
import de.jottyfan.quickiemod.block.BlockStacker;
import de.jottyfan.quickiemod.blockentity.ModBlockentity;
import de.jottyfan.quickiemod.container.BlockStackerScreenHandler;
import de.jottyfan.quickiemod.container.ImplementedInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3908;

public class BlockStackerEntity
extends class_2586
implements class_3908,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)BlockStackerScreenHandler.SLOTSIZE, (Object)class_1799.field_8037);

    public BlockStackerEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockentity.BLOCKSTACKER_BLOCKENTITY, blockPos, blockState);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public List<class_1799> getWhiteList() {
        int counter = 0;
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (class_1799 stack : this.inventory) {
            if (++counter >= 10) continue;
            list.add(stack);
        }
        return list;
    }

    public List<class_1799> getBlackList() {
        int counter = 0;
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (class_1799 stack : this.inventory) {
            if (++counter <= 9) continue;
            list.add(stack);
        }
        return list;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BlockStackerScreenHandler(syncId, playerInventory, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.inventory);
    }

    protected void method_11007(class_11372 view) {
        class_1262.method_5426((class_11372)view, this.inventory);
        super.method_11007(view);
    }

    public static final Boolean filter(class_1799 current, class_1799 pattern, Boolean whitelist) {
        Boolean matches = pattern.method_7909().equals(current.method_7909());
        return whitelist != false ? matches : matches == false;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BlockStackerEntity entity) {
        if (!world.field_9236) {
            pos.method_10074();
            BlockStacker block = (BlockStacker)state.method_26204();
            class_2586 source = world.method_8321(pos.method_10093(block.getSourceOffset()));
            class_2586 dest = world.method_8321(pos.method_10093(block.getDestOffset()));
            Boolean sourceIsLootable = source instanceof class_2621;
            Boolean destIsLootable = dest instanceof class_2621;
            if (sourceIsLootable.booleanValue() && destIsLootable.booleanValue()) {
                class_2621 lootableSource = (class_2621)source;
                class_2621 lootableDest = (class_2621)dest;
                BlockStackerEntity.transferOneStack(lootableSource, lootableDest, entity.getWhiteList(), entity.getBlackList());
            }
        }
    }

    private static final Boolean transferOneStack(class_2621 source, class_2621 dest, List<class_1799> whiteList, List<class_1799> blackList) {
        ArrayList<class_1792> checked = new ArrayList<class_1792>();
        for (class_1799 stack : blackList) {
            if (stack == null || stack.method_7960()) continue;
            checked.add(stack.method_7909());
        }
        Boolean found = false;
        if (BlockStackerEntity.hasItems(whiteList).booleanValue()) {
            class_1792 matchItem = BlockStackerEntity.findNextItem(whiteList, checked);
            while (!found.booleanValue() && matchItem != null) {
                checked.add(matchItem);
                ArrayList<class_1792> matchItems = new ArrayList<class_1792>();
                matchItems.add(matchItem);
                found = BlockStackerEntity.transferOneStack(source, dest, matchItems, true);
                matchItem = BlockStackerEntity.findNextItem(whiteList, checked);
            }
        } else {
            found = BlockStackerEntity.transferOneStack(source, dest, checked, false);
        }
        return found;
    }

    private static final Boolean transferOneStack(class_2621 source, class_2621 dest, List<class_1792> ignoreItems, Boolean whitelist) {
        Boolean result = false;
        Integer sourceSlot = BlockStackerEntity.findItemStackPos(source, ignoreItems, whitelist);
        if (sourceSlot != null && !class_1802.field_8162.equals(source.method_5438(sourceSlot.intValue()).method_7909())) {
            class_1799 sourceStack = source.method_5438(sourceSlot.intValue());
            Integer destSlot = BlockStackerEntity.findItemStackPos(dest, sourceStack);
            if (destSlot != null) {
                Integer travellers;
                Integer occupied = dest.method_5438(destSlot.intValue()).method_7947();
                Integer free = dest.method_5438(destSlot.intValue()).method_7914() - occupied;
                Integer candidates = source.method_5438(sourceSlot.intValue()).method_7947();
                Integer n = travellers = candidates > free ? free : candidates;
                if (travellers > 0) {
                    Quickiemod.LOGGER.debug("transfer {}/{} of {} from slot {} to slot {} on top of {} ones", new Object[]{travellers, candidates, source.method_5438(sourceSlot.intValue()).method_7909().toString(), sourceSlot, destSlot, occupied});
                    source.method_5438(sourceSlot.intValue()).method_7934(travellers.intValue());
                    if (source.method_5438(sourceSlot.intValue()).method_7947() < 1) {
                        source.method_5441(sourceSlot.intValue());
                    }
                    dest.method_5438(destSlot.intValue()).method_7933(travellers.intValue());
                    result = true;
                }
            } else {
                Integer destFreeSlot = BlockStackerEntity.findItemStackPos(dest, true);
                if (destFreeSlot != null) {
                    Quickiemod.LOGGER.debug("transfer all of {} from slot {} to slot {}", new Object[]{source.method_5438(sourceSlot.intValue()).method_7909().toString(), sourceSlot, destSlot});
                    dest.method_5447(destFreeSlot.intValue(), source.method_5441(sourceSlot.intValue()));
                    result = true;
                }
            }
        }
        return result;
    }

    private static final Boolean hasItems(List<class_1799> list) {
        Boolean result = false;
        for (class_1799 stack : list) {
            result = result != false || stack != null && !stack.method_7960() && stack.method_7947() > 0;
        }
        return result;
    }

    private static final class_1792 findNextItem(List<class_1799> inventory, List<class_1792> exclude) {
        for (class_1799 stack : inventory) {
            class_1792 item;
            if (stack.method_7960() || exclude.contains(item = stack.method_7909())) continue;
            return item;
        }
        return null;
    }

    private static final Integer findItemStackPos(class_2621 lcbe, class_1799 sourceStack) {
        Integer counter = lcbe.method_5439();
        while (counter > 0) {
            Integer n = counter;
            counter = counter - 1;
            class_1799 stack = lcbe.method_5438(counter.intValue());
            if (!sourceStack.method_7909().equals(stack.method_7909()) || stack.method_7947() >= stack.method_7914()) continue;
            return counter;
        }
        return null;
    }

    private static final Integer findItemStackPos(class_2621 lcbe, Boolean empty) {
        Integer counter = lcbe.method_5439();
        while (counter > 0) {
            Integer n = counter;
            counter = counter - 1;
            class_1799 stack = lcbe.method_5438(counter.intValue());
            if (!empty.equals(class_1799.field_8037.equals(stack))) continue;
            return counter;
        }
        return null;
    }

    private static final Integer findItemStackPos(class_2621 lcbe, List<class_1792> filterItems, Boolean whitelist) {
        if (whitelist == null) {
            whitelist = true;
            Quickiemod.LOGGER.error("whitelist is null");
        }
        if (filterItems == null || filterItems.size() < 1) {
            if (whitelist.booleanValue()) {
                return null;
            }
            return BlockStackerEntity.findItemStackPos(lcbe, false);
        }
        Integer counter = lcbe.method_5439();
        while (counter > 0) {
            Integer n = counter;
            counter = counter - 1;
            class_1799 stack = lcbe.method_5438(counter.intValue());
            Boolean found = whitelist != false ? filterItems.contains(stack.method_7909()) : !filterItems.contains(stack.method_7909());
            if (!found.booleanValue()) continue;
            return counter;
        }
        return null;
    }

    @Override
    public int method_5439() {
        return this.inventory.size();
    }
}

