/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.kuromaterials.item;

import com.jahirtrap.kuromaterials.init.ModComponents;
import com.jahirtrap.kuromaterials.util.CommonUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class LinkRelicItem
extends Item {
    private static final DataComponentType<String> PLAYER_NAME_KEY = ModComponents.PLAYER_NAME_KEY.get();

    public LinkRelicItem(Item.Properties properties) {
        super(properties.stacksTo(16).useCooldown(1.5f));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide() && this.getPlayerName(player.getItemInHand(hand)) != null) {
            player.startUsingItem(hand);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.getCooldowns().isOnCooldown(stack) && target instanceof Player) {
            Player targetPlayer = (Player)target;
            this.setPlayerName(player.getItemInHand(hand), targetPlayer.getName().getString(), player);
            targetPlayer.level().playSound(null, targetPlayer.blockPosition(), SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, target, hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ServerPlayer targetPlayer = level.getServer().getPlayerList().getPlayerByName(this.getPlayerName(stack));
            if (targetPlayer != null && targetPlayer != serverPlayer) {
                ServerLevel serverLevel;
                ResourceKey targetDimension = targetPlayer.level().dimension();
                BlockPos targetPos = targetPlayer.blockPosition();
                ServerLevel serverLevel2 = serverLevel = level.getServer() != null ? level.getServer().getLevel(targetDimension) : null;
                if (serverLevel != null) {
                    if (level.dimension() != targetDimension) {
                        serverPlayer.teleportTo(level.getServer().getLevel(targetDimension), (double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, Relative.ALL, serverPlayer.getYRot(), serverPlayer.getXRot(), true);
                    }
                    serverPlayer.teleportTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
                    serverLevel.playSound(null, serverPlayer.blockPosition(), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
                }
            } else {
                level.playSound(null, serverPlayer.blockPosition(), (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.PLAYERS);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (this.getPlayerName(stack) != null) {
            tooltip.accept(CommonUtils.coloredTextComponent(this.getPlayerName(stack) + " " + Component.translatable((String)"kuromaterials.link_relic.linked").getString(), ChatFormatting.GRAY));
        }
    }

    private String getPlayerName(ItemStack stack) {
        return (String)stack.get(PLAYER_NAME_KEY);
    }

    private void setPlayerName(ItemStack stack, String name, Player player) {
        ItemStack result = stack.copyWithCount(1);
        result.set(PLAYER_NAME_KEY, (Object)name);
        result.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        if (!player.hasInfiniteMaterials() && stack.getCount() == 1) {
            stack.applyComponents(result.getComponents());
        } else {
            stack.consume(1, (LivingEntity)player);
            if (!player.getInventory().add(result)) {
                player.drop(result, false);
            }
        }
        player.displayClientMessage(CommonUtils.coloredTextComponent(name + " " + Component.translatable((String)"kuromaterials.link_relic.linked").getString(), ChatFormatting.GOLD), true);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }
}

