/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.kuromaterials.init;

import com.jahirtrap.kuromaterials.init.ModMaterials;
import com.jahirtrap.kuromaterials.item.BaseSmithingTemplateItem;
import com.jahirtrap.kuromaterials.item.LinkRelicItem;
import com.jahirtrap.kuromaterials.item.TravelerRelicItem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"kuromaterials");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"kuromaterials");
    public static final RegistryObject<Item> ZURITE_INGOT = ModContent.registerItem("zurite_ingot", Item::new, new Item.Properties().fireResistant());
    public static final RegistryObject<Block> ZURITE_BLOCK = ModContent.registerBlock("zurite_block", Block::new, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> ZURITE_UPGRADE_SMITHING_TEMPLATE = ModContent.registerItem("zurite_upgrade_smithing_template", p -> BaseSmithingTemplateItem.createUpgradeTemplate("zurite", p), new Item.Properties());
    public static final List<RegistryObject<Item>> ZURITE_TOOLS = ModContent.registerTools("zurite", ModMaterials.Tool.ZURITE, new float[]{5.0f, -3.0f, -4.0f, 0.0f}, new Item.Properties().fireResistant());
    public static final List<RegistryObject<Item>> ZURITE_ARMOR = ModContent.registerArmor(ModMaterials.Armor.ZURITE, new Item.Properties().fireResistant());
    public static final RegistryObject<Item> TRAVELER_RELIC_FRAGMENT = ModContent.registerItem("traveler_relic_fragment", p -> new TravelerRelicItem(true, (Item.Properties)p), new Item.Properties().fireResistant().rarity(Rarity.RARE));
    public static final RegistryObject<Item> TRAVELER_RELIC = ModContent.registerItem("traveler_relic", p -> new TravelerRelicItem(false, (Item.Properties)p), new Item.Properties().fireResistant().rarity(Rarity.RARE));
    public static final RegistryObject<Item> LINK_RELIC = ModContent.registerItem("link_relic", LinkRelicItem::new, new Item.Properties().fireResistant().rarity(Rarity.RARE));
    public static final RegistryObject<Block> ANCHOR_STONE = ModContent.registerBlock("anchor_stone", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(5.0f, 6.0f).sound(SoundType.LODESTONE).requiresCorrectToolForDrops(), new Item.Properties().fireResistant());

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp, Item.Properties itemProp) {
        RegistryObject<Block> blockReg = ModContent.registerBlock(name, function, blockProp);
        ModContent.registerItem(name, p -> new BlockItem((Block)blockReg.get(), p), itemProp.useBlockDescriptionPrefix());
        return blockReg;
    }

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp) {
        return BLOCKS.register(name, () -> (Block)function.apply(blockProp.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kuromaterials", (String)name)))));
    }

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kuromaterials", (String)name)))));
    }

    private static List<RegistryObject<Item>> registerTools(String name, ToolMaterial material, float[] attr, Item.Properties itemProp) {
        return List.of(ModContent.registerItem(name + "_sword", p -> new Item(p.sword(material, 3.0f, -2.4f)), itemProp), ModContent.registerItem(name + "_pickaxe", p -> new Item(p.pickaxe(material, 1.0f, -2.8f)), itemProp), ModContent.registerItem(name + "_axe", p -> new AxeItem(material, attr[0], attr[1], p), itemProp), ModContent.registerItem(name + "_shovel", p -> new ShovelItem(material, 1.5f, -3.0f, p), itemProp), ModContent.registerItem(name + "_hoe", p -> new HoeItem(material, attr[2], attr[3], p), itemProp));
    }

    private static List<RegistryObject<Item>> registerArmor(ArmorMaterial material, Item.Properties itemProp) {
        String name = material.assetId().location().getPath();
        return List.of(ModContent.registerItem(name + "_helmet", p -> new Item(p.humanoidArmor(material, ArmorType.HELMET)), itemProp), ModContent.registerItem(name + "_chestplate", p -> new Item(p.humanoidArmor(material, ArmorType.CHESTPLATE)), itemProp), ModContent.registerItem(name + "_leggings", p -> new Item(p.humanoidArmor(material, ArmorType.LEGGINGS)), itemProp), ModContent.registerItem(name + "_boots", p -> new Item(p.humanoidArmor(material, ArmorType.BOOTS)), itemProp));
    }

    public static void init(BusGroup bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

