/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.kuromaterials.item;

import com.jahirtrap.kuromaterials.init.ModComponents;
import com.jahirtrap.kuromaterials.init.ModTags;
import com.jahirtrap.kuromaterials.util.CommonUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;

public class TravelerRelicItem
extends Item {
    private static final DataComponentType<GlobalPos> GLOBAL_POS_KEY = (DataComponentType)ModComponents.GLOBAL_POS_KEY.get();
    private final boolean fragment;

    public TravelerRelicItem(boolean fragment, Item.Properties properties) {
        super(properties.stacksTo(16).useCooldown(1.5f));
        this.fragment = fragment;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = TravelerRelicItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getBlockPos();
        boolean anchor = level.getBlockState(pos).is(ModTags.Blocks.ANCHOR_BLOCKS);
        if (!(level.isClientSide() || !anchor && !player.isSecondaryUseActive() || !anchor && this.fragment)) {
            BlockPos targetPos = anchor ? pos.above() : player.blockPosition();
            this.setGlobalPos(stack, (ResourceKey<Level>)level.dimension(), targetPos, player, hand);
            level.playSound(null, anchor ? targetPos.below() : targetPos, SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS);
            return InteractionResult.SUCCESS_SERVER;
        }
        if (!level.isClientSide() && this.getGlobalPos(stack) != null) {
            player.startUsingItem(hand);
        }
        return super.use(level, player, hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide() && entity instanceof ServerPlayer) {
            ServerLevel serverLevel;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ResourceKey targetDimension = this.getGlobalPos(stack).dimension();
            BlockPos targetPos = this.getGlobalPos(stack).pos();
            ServerLevel serverLevel2 = serverLevel = level.getServer() != null ? level.getServer().getLevel(targetDimension) : null;
            if (serverLevel != null && (!this.fragment || serverLevel.getBlockState(targetPos.below()).is(ModTags.Blocks.ANCHOR_BLOCKS))) {
                if (level.dimension() != targetDimension) {
                    serverPlayer.teleportTo(level.getServer().getLevel(targetDimension), (double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, Relative.ALL, serverPlayer.getYRot(), serverPlayer.getXRot(), true);
                }
                serverPlayer.teleportTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
                serverLevel.playSound(null, serverPlayer.blockPosition(), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
            } else {
                level.playSound(null, serverPlayer.blockPosition(), (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.PLAYERS);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (this.getGlobalPos(stack) != null) {
            BlockPos targetPos = this.getGlobalPos(stack).pos();
            tooltip.accept(CommonUtils.coloredTextComponent(CommonUtils.snakeToTitleCase(this.getGlobalPos(stack).dimension().location().getPath()) + " [" + targetPos.getX() + ", " + targetPos.getY() + ", " + targetPos.getZ() + "]", ChatFormatting.GRAY));
        }
    }

    private GlobalPos getGlobalPos(ItemStack stack) {
        return (GlobalPos)stack.get(GLOBAL_POS_KEY);
    }

    private void setGlobalPos(ItemStack stack, ResourceKey<Level> targetDimension, BlockPos targetPos, Player player, InteractionHand hand) {
        ItemStack result = stack.copyWithCount(1);
        result.set(GLOBAL_POS_KEY, (Object)new GlobalPos(targetDimension, targetPos));
        result.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        if (!player.hasInfiniteMaterials() && stack.getCount() == 1) {
            stack.applyComponents(result.getComponents());
        } else {
            stack.consume(1, (LivingEntity)player);
            if (!player.getInventory().add(result)) {
                player.drop(result, false);
            }
        }
        player.displayClientMessage(CommonUtils.coloredTextComponent(CommonUtils.snakeToTitleCase(targetDimension.location().getPath()) + " [" + targetPos.getX() + ", " + targetPos.getY() + ", " + targetPos.getZ() + "]", ChatFormatting.GOLD), true);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }
}

