/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator;

import block.event.separator.AnimationMode;
import block.event.separator.SeparationMode;
import com.google.common.base.Suppliers;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockEventSeparatorMod {
    public static final String MOD_ID = "block-event-separator";
    public static final String MOD_NAME = "Block Event Separator";
    public static final String MOD_VERSION = "1.3.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Block Event Separator");
    private static final List<Runnable> SERVER_SEPARATION_MODE_LISTENERS = new LinkedList<Runnable>();
    private static final List<Runnable> SERVER_SEPARATION_INTERVAL_LISTENERS = new LinkedList<Runnable>();
    private static final List<Runnable> ANIMATION_MODE_LISTENERS = new LinkedList<Runnable>();
    public static Supplier<Integer> blockEventDistanceSupplier = Suppliers.ofInstance((Object)4);
    public static boolean isConnectedToBesServer;
    private static SeparationMode serverSeparationMode;
    private static SeparationMode clientSeparationMode;
    private static int serverSeparationInterval;
    private static int clientSeparationInterval;
    private static AnimationMode animationMode;

    public static SeparationMode getServerSeparationMode() {
        return serverSeparationMode;
    }

    public static void setServerSeparationMode(SeparationMode mode) {
        if (mode != null && mode != serverSeparationMode) {
            serverSeparationMode = mode;
            SERVER_SEPARATION_MODE_LISTENERS.forEach(Runnable::run);
        }
    }

    public static void addServerSeparationModeListener(Runnable listener) {
        SERVER_SEPARATION_MODE_LISTENERS.add(listener);
    }

    public static SeparationMode getClientSeparationMode() {
        return clientSeparationMode;
    }

    public static void setClientSeparationMode(SeparationMode mode) {
        if (mode != null && mode != clientSeparationMode) {
            clientSeparationMode = mode;
        }
    }

    public static int getServerSeparationInterval() {
        return serverSeparationInterval;
    }

    public static void setServerSeparationInterval(int interval) {
        if (interval != serverSeparationInterval) {
            serverSeparationInterval = interval;
            SERVER_SEPARATION_INTERVAL_LISTENERS.forEach(Runnable::run);
        }
    }

    public static void addServerSeparationIntervalListener(Runnable listener) {
        SERVER_SEPARATION_INTERVAL_LISTENERS.add(listener);
    }

    public static int getClientSeparationInterval() {
        return clientSeparationInterval;
    }

    public static void setClientSeparationInterval(int interval) {
        if (interval != clientSeparationInterval) {
            clientSeparationInterval = interval;
        }
    }

    public static AnimationMode getAnimationMode() {
        return animationMode;
    }

    public static void setAnimationMode(AnimationMode mode) {
        if (mode != null && mode != animationMode) {
            animationMode = mode;
            ANIMATION_MODE_LISTENERS.forEach(Runnable::run);
        }
    }

    public static void addAnimationModeListener(Runnable listener) {
        ANIMATION_MODE_LISTENERS.add(listener);
    }

    static {
        serverSeparationMode = SeparationMode.OFF;
        clientSeparationMode = SeparationMode.OFF;
        serverSeparationInterval = 1;
        clientSeparationInterval = 1;
        animationMode = AnimationMode.DEFAULT;
    }
}

