/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator.mixin.common;

import block.event.separator.BlockEvent;
import block.event.separator.BlockEventSeparatorMod;
import block.event.separator.Counters;
import block.event.separator.SeparationMode;
import block.event.separator.interfaces.mixin.IMinecraftServer;
import block.event.separator.interfaces.mixin.IServerLevel;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2623;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3218.class}, priority=1001)
public abstract class ServerLevelMixin
extends class_1937
implements IServerLevel {
    @Shadow
    private MinecraftServer field_13959;
    @Shadow
    private ObjectLinkedOpenHashSet<class_1919> field_13950;
    private final Queue<BlockEvent> successfulBlockEvents_bes = new LinkedList<BlockEvent>();
    private boolean ignoreLastBatch_bes;
    private int gcp_microtick;

    private ServerLevelMixin(class_5269 data, class_5321<class_1937> resourceKey, class_5455 registries, class_6880<class_2874> dimensionType, Supplier<class_3695> profiler, boolean isClientSide, boolean isDebug, long seed, int maxChainedNeighborUpdates) {
        super(data, resourceKey, registries, dimensionType, isClientSide, isDebug, seed, maxChainedNeighborUpdates);
    }

    @Shadow
    private boolean method_14174(class_1919 data) {
        return false;
    }

    @Inject(method={"runBlockEvents"}, at={@At(value="HEAD")})
    private void preBlockEvents(CallbackInfo ci) {
        Counters.currentDepth = 0;
        Counters.currentBatch = this.field_13950.size();
        Counters.total = 0;
        Counters.movingBlocksTotal = 0;
    }

    @Inject(method={"runBlockEvents"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, ordinal=0, target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;isEmpty()Z")})
    private void onNextBlockEvent(CallbackInfo ci) {
        if (!this.field_13950.isEmpty()) {
            if (Counters.currentBatch == 0) {
                ++Counters.currentDepth;
                Counters.currentBatch = this.field_13950.size();
                this.ignoreLastBatch_bes = true;
            }
            --Counters.currentBatch;
        }
    }

    @Inject(method={"doBlockEvent"}, at={@At(value="HEAD")})
    private void startBlockEvent(class_1919 data, CallbackInfoReturnable<Boolean> cir) {
        Counters.movingBlocksThisEvent = 0;
    }

    @Inject(method={"doBlockEvent"}, cancellable=true, at={@At(value="RETURN")})
    private void cancelBlockEventPacket(class_1919 data, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            Counters.currentDepth = Math.max(Counters.currentDepth, this.gcp_microtick);
            ++Counters.total;
            int offset = switch (BlockEventSeparatorMod.getServerSeparationMode()) {
                case SeparationMode.DEPTH -> Counters.currentDepth;
                case SeparationMode.INDEX -> Counters.total - 1;
                case SeparationMode.BLOCK -> Counters.movingBlocksTotal - Counters.movingBlocksThisEvent;
                default -> 0;
            };
            this.ignoreLastBatch_bes = false;
            BlockEvent blockEvent = BlockEvent.of(data, offset);
            this.successfulBlockEvents_bes.add(blockEvent);
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"runBlockEvents"}, at={@At(value="RETURN")})
    private void postBlockEvents(CallbackInfo ci) {
        if (this.ignoreLastBatch_bes) {
            --Counters.currentDepth;
        }
        ((IMinecraftServer)this.field_13959).postBlockEvents_bes();
    }

    @Override
    public void sendBlockEvents_bes(int offsetLimit) {
        while (!this.successfulBlockEvents_bes.isEmpty()) {
            BlockEvent blockEvent = this.successfulBlockEvents_bes.peek();
            int offset = blockEvent.animationOffset;
            if (offset > offsetLimit) break;
            this.successfulBlockEvents_bes.poll();
            this.sendBlockEvent_bes(blockEvent);
        }
    }

    private void sendBlockEvent_bes(BlockEvent be) {
        int x = be.pos.method_10263();
        int y = be.pos.method_10264();
        int z = be.pos.method_10260();
        float range = this.getBlockEventRange_bes();
        class_5321 dimension = this.method_27983();
        class_2623 packet = new class_2623(be.pos, be.block, be.type, be.data);
        this.field_13959.method_3760().method_14605(null, (double)x, (double)y, (double)z, (double)range, dimension, (class_2596)packet);
    }

    private float getBlockEventRange_bes() {
        return 16.0f * (float)BlockEventSeparatorMod.blockEventDistanceSupplier.get().intValue();
    }
}

