/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator.g4mespeed;

import block.event.separator.AnimationMode;
import block.event.separator.BlockEventSeparatorMod;
import block.event.separator.SeparationMode;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSIModuleManager;
import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSKeyCode;
import com.g4mesoft.hotkey.GSKeyManager;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.types.GSIntegerSetting;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class BlockEventSeparatorModule
implements GSIModule {
    public static final String KEY_CATEGORY = "blockeventseparator";
    private static final GSSettingCategory SETTING_CATEGORY = new GSSettingCategory("blockeventseparator");
    private final GSIntegerSetting sSeparationMode;
    private final GSIntegerSetting sSeparationInterval;
    private final GSIntegerSetting cAnimationMode;

    public BlockEventSeparatorModule() {
        this.sSeparationMode = new GSIntegerSetting("separationMode", SeparationMode.OFF.index, 0, SeparationMode.getCount() - 1);
        this.sSeparationInterval = new GSIntegerSetting("separationInterval", 1, 1, 64);
        this.cAnimationMode = new GSIntegerSetting("animationMode", AnimationMode.DEFAULT.index, 0, AnimationMode.getCount() - 1);
    }

    public void init(GSIModuleManager manager) {
        manager.runOnClient(clientManager -> {
            GSTpsModule tpsModule = (GSTpsModule)clientManager.getModule(GSTpsModule.class);
            tpsModule.setFixedMovementOnDefaultTps(true);
            clientManager.getSettingManager().addChangeListener(new GSISettingChangeListener(){

                public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
                    if (setting == BlockEventSeparatorModule.this.cAnimationMode) {
                        BlockEventSeparatorModule.this.onAnimationModeSettingChanged();
                    }
                }
            });
            this.onAnimationModeSettingChanged();
        });
        manager.runOnServer(serverManager -> {
            GSTpsModule tpsModule = (GSTpsModule)serverManager.getModule(GSTpsModule.class);
            tpsModule.sImmediateBlockBroadcast.setEnabledInGui(false);
            tpsModule.sImmediateBlockBroadcast.set(false);
            tpsModule.sParanoidMode.setEnabledInGui(false);
            tpsModule.sParanoidMode.set(false);
            BlockEventSeparatorMod.blockEventDistanceSupplier = () -> ((GSIntegerSetting)tpsModule.sBlockEventDistance).get();
            serverManager.getSettingManager().addChangeListener(new GSISettingChangeListener(){

                public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
                    if (setting == BlockEventSeparatorModule.this.sSeparationMode) {
                        BlockEventSeparatorModule.this.onSeparationModeSettingChanged();
                    } else if (setting == BlockEventSeparatorModule.this.sSeparationInterval) {
                        BlockEventSeparatorModule.this.onSeparationIntervalSettingChanged();
                    }
                }
            });
            BlockEventSeparatorMod.addServerSeparationModeListener(() -> {
                SeparationMode mode = BlockEventSeparatorMod.getServerSeparationMode();
                if (mode.index != this.sSeparationMode.get()) {
                    this.sSeparationMode.set(mode.index);
                }
            });
            BlockEventSeparatorMod.addServerSeparationIntervalListener(() -> {
                int interval = BlockEventSeparatorMod.getServerSeparationInterval();
                if (interval != this.sSeparationInterval.get()) {
                    this.sSeparationInterval.set(interval);
                }
            });
            this.onSeparationModeSettingChanged();
            this.onSeparationIntervalSettingChanged();
        });
    }

    private void onSeparationModeSettingChanged() {
        SeparationMode mode = SeparationMode.fromIndex(this.sSeparationMode.get());
        if (mode != BlockEventSeparatorMod.getServerSeparationMode()) {
            BlockEventSeparatorMod.setServerSeparationMode(mode);
        }
    }

    private void onSeparationIntervalSettingChanged() {
        int interval = this.sSeparationInterval.get();
        if (interval != BlockEventSeparatorMod.getServerSeparationInterval()) {
            BlockEventSeparatorMod.setServerSeparationInterval(interval);
        }
    }

    private void onAnimationModeSettingChanged() {
        AnimationMode mode = AnimationMode.fromIndex(this.cAnimationMode.get());
        if (mode != BlockEventSeparatorMod.getAnimationMode()) {
            BlockEventSeparatorMod.setAnimationMode(mode);
        }
    }

    public void registerHotkeys(GSKeyManager keyManager) {
        keyManager.registerKey("toggleSeparationMode", KEY_CATEGORY, GSKeyCode.UNKNOWN_KEY, () -> {
            int nextValue = this.sSeparationMode.get() + this.sSeparationMode.getInterval();
            if (nextValue > this.sSeparationMode.getMin()) {
                nextValue = this.sSeparationMode.getMin();
            }
            this.sSeparationMode.set(nextValue);
        }, GSEKeyEventType.PRESS);
        keyManager.registerKey("toggleAnimationMode", KEY_CATEGORY, GSKeyCode.UNKNOWN_KEY, () -> {
            int nextValue = this.cAnimationMode.get() + this.cAnimationMode.getInterval();
            if (nextValue > this.cAnimationMode.getMax()) {
                nextValue = this.cAnimationMode.getMax();
            }
            this.cAnimationMode.set(nextValue);
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AnimationMode mode = BlockEventSeparatorMod.getAnimationMode();
                class_5250 text = class_2561.method_43470((String)("Set animation mode to " + mode.name));
                player.method_7353((class_2561)text, true);
            }
        }, GSEKeyEventType.PRESS);
    }

    public void registerServerSettings(GSSettingManager settings) {
        settings.registerSetting(SETTING_CATEGORY, (GSSetting)this.sSeparationMode);
        settings.registerSetting(SETTING_CATEGORY, (GSSetting)this.sSeparationInterval);
    }

    public void registerClientSettings(GSSettingManager settings) {
        settings.registerSetting(SETTING_CATEGORY, (GSSetting)this.cAnimationMode);
    }
}

