/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator.mixin.common;

import block.event.separator.BlockEventSeparatorMod;
import block.event.separator.Counters;
import block.event.separator.SeparationMode;
import block.event.separator.interfaces.mixin.IMinecraftServer;
import block.event.separator.interfaces.mixin.IServerLevel;
import block.event.separator.network.HandshakePayload;
import block.event.separator.network.Payload;
import block.event.separator.network.PayloadWrapper;
import block.event.separator.network.TickPayload;
import block.event.separator.utils.MathUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.class_10209;
import net.minecraft.class_1928;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2761;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3695;
import net.minecraft.class_8710;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements IMinecraftServer {
    @Shadow
    private int field_4572;
    @Shadow
    private class_3324 field_4550;
    @Shadow
    private class_8915 field_47142;
    private final Set<UUID> connectedPlayers = new HashSet<UUID>();
    private SeparationMode mode_bes;
    private int separationInterval_bes;
    private int prevPrevMaxOffset_bes;
    private int prevMaxOffset_bes;
    private int maxOffset_bes;
    private int subticks_bes;
    private int subticksTarget_bes;
    private int maxBlockEventDepth_bes;
    private int maxBlockEventTotal_bes;
    private int maxMovingBlocksTotal_bes;

    @Shadow
    protected abstract Iterable<class_3218> method_3738();

    @Shadow
    protected abstract void method_61254();

    @Inject(method={"loadLevel"}, at={@At(value="HEAD")})
    private void resetServerSettings(CallbackInfo ci) {
        BlockEventSeparatorMod.setServerSeparationMode(SeparationMode.OFF);
        BlockEventSeparatorMod.setServerSeparationInterval(1);
    }

    @Inject(method={"tickChildren"}, cancellable=true, at={@At(value="HEAD")})
    private void cancelTick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        if (this.subticks_bes > 0) {
            if (this.field_4572 % 20 == 0) {
                this.syncTime_bes();
            }
            this.method_61254();
            ci.cancel();
        }
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="HEAD")})
    private void adjustNextTickTime(CallbackInfo ci) {
        if (!this.field_47142.method_54751() || this.isPaused()) {
            return;
        }
        if (this.subticks_bes == 0) {
            this.mode_bes = BlockEventSeparatorMod.getServerSeparationMode();
            this.separationInterval_bes = BlockEventSeparatorMod.getServerSeparationInterval();
            this.prevPrevMaxOffset_bes = this.prevMaxOffset_bes;
            this.prevMaxOffset_bes = this.maxOffset_bes;
            this.maxOffset_bes = switch (this.mode_bes) {
                case SeparationMode.DEPTH -> this.maxBlockEventDepth_bes;
                case SeparationMode.INDEX -> this.maxBlockEventTotal_bes - 1;
                case SeparationMode.BLOCK -> this.maxMovingBlocksTotal_bes - 1;
                default -> 0;
            };
            this.syncNextTick_bes();
            this.maxBlockEventDepth_bes = 0;
            this.maxBlockEventTotal_bes = 1;
            this.maxMovingBlocksTotal_bes = 1;
            this.subticksTarget_bes = this.separationInterval_bes * MathUtils.max(this.prevPrevMaxOffset_bes, this.prevMaxOffset_bes, this.maxOffset_bes);
        }
        this.syncBlockEvents_bes();
        if (++this.subticks_bes > this.subticksTarget_bes) {
            this.subticks_bes = 0;
        }
    }

    @Override
    public void onPlayerJoin_bes(class_3222 player) {
    }

    @Override
    public void onPlayerLeave_bes(class_3222 player) {
        this.connectedPlayers.remove(player.method_5667());
    }

    @Override
    public void postBlockEvents_bes() {
        this.maxBlockEventDepth_bes = Math.max(this.maxBlockEventDepth_bes, Counters.currentDepth);
        this.maxBlockEventTotal_bes = Math.max(this.maxBlockEventTotal_bes, Counters.total);
        this.maxMovingBlocksTotal_bes = Math.max(this.maxMovingBlocksTotal_bes, Counters.movingBlocksTotal);
    }

    @Override
    public void onHandshake_bes(class_3222 player, String modVersion) {
        if (this.connectedPlayers.add(player.method_5667())) {
            player.field_13987.method_14364((class_2596)new class_2658((class_8710)new PayloadWrapper(new HandshakePayload("1.3.0"))));
            this.field_4550.method_14576(player);
        }
    }

    @Override
    public boolean isBesClient(class_3222 player) {
        return this.connectedPlayers.contains(player.method_5667());
    }

    private void syncTime_bes() {
        class_3695 profiler = class_10209.method_64146();
        for (class_3218 level : this.method_3738()) {
            profiler.method_15396("timeSync");
            long gameTime = level.method_8510();
            long dayTime = level.method_8532();
            boolean doDayLightCycle = level.method_64395().method_8355(class_1928.field_19396);
            class_2761 packet = new class_2761(gameTime, dayTime, doDayLightCycle);
            this.field_4550.method_14589((class_2596)packet, level.method_27983());
            profiler.method_15407();
        }
    }

    private void syncNextTick_bes() {
        this.send_bes(new TickPayload(this.maxOffset_bes, this.separationInterval_bes, this.mode_bes));
    }

    private void syncBlockEvents_bes() {
        int offsetLimit = this.subticks_bes / this.separationInterval_bes;
        for (class_3218 level : this.method_3738()) {
            ((IServerLevel)level).sendBlockEvents_bes(offsetLimit);
        }
    }

    private void send_bes(Payload payload) {
        class_2658 packet = null;
        for (UUID uuid : this.connectedPlayers) {
            class_3222 player = this.field_4550.method_14602(uuid);
            if (player == null) continue;
            if (packet == null) {
                packet = new class_2658((class_8710)new PayloadWrapper(payload));
            }
            player.field_13987.method_14364(packet);
        }
    }
}

