/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator;

import java.util.HashMap;
import java.util.Map;

public enum SeparationMode {
    OFF(0, "off", ""),
    DEPTH(1, "depth", "Block events are separated by depth (colloquially known as \"microticks\" or \"BED\"). Block events at the same depth start animating simultaneously."),
    INDEX(2, "index", "Block events are separated by index, based on the order in which they were executed. Each block event starts after the previous."),
    BLOCK(3, "block", "Moving blocks are separated by index, based on the order in which they were created.");

    private static final SeparationMode[] ALL;
    private static final Map<String, SeparationMode> BY_NAME;
    public final int index;
    public final String name;
    public final String description;

    private SeparationMode(int index, String name, String description) {
        this.index = index;
        this.name = name;
        this.description = description;
    }

    public static SeparationMode fromName(String name) {
        return BY_NAME.get(name);
    }

    public static SeparationMode fromIndex(int index) {
        if (index >= 0 && index < ALL.length) {
            return ALL[index];
        }
        return null;
    }

    public static int getCount() {
        return ALL.length;
    }

    static {
        SeparationMode[] modes = SeparationMode.values();
        ALL = new SeparationMode[modes.length];
        BY_NAME = new HashMap<String, SeparationMode>();
        SeparationMode[] separationModeArray = modes;
        int n = separationModeArray.length;
        for (int i = 0; i < n; ++i) {
            SeparationMode mode;
            SeparationMode.ALL[mode.index] = mode = separationModeArray[i];
            BY_NAME.put(mode.name, mode);
        }
    }
}

