/*
 * Decompiled with CFR 0.152.
 */
package block.event.separator.command;

import block.event.separator.BlockEventSeparatorMod;
import block.event.separator.SeparationMode;
import block.event.separator.interfaces.mixin.IMinecraftServer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BlockEventSeparatorCommand {
    private static final String[] MODES;
    private static final SimpleCommandExceptionType ERROR_INVALID_NAME;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockeventseparator").requires(source -> source.method_9259(2) && BlockEventSeparatorCommand.isBesClient(source))).executes(context -> BlockEventSeparatorCommand.queryMode((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").executes(context -> BlockEventSeparatorCommand.queryMode((class_2168)context.getSource()))).then(class_2170.method_9244((String)"new mode", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])MODES, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> BlockEventSeparatorCommand.setMode((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"new mode")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"interval").executes(context -> BlockEventSeparatorCommand.queryInterval((class_2168)context.getSource()))).then(class_2170.method_9244((String)"new interval", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> BlockEventSeparatorCommand.setInterval((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"new interval")))));
        dispatcher.register(builder);
    }

    private static boolean isBesClient(class_2168 source) {
        MinecraftServer server = source.method_9211();
        class_3222 player = source.method_44023();
        return player != null && ((IMinecraftServer)server).isBesClient(player);
    }

    private static int queryMode(class_2168 source) {
        SeparationMode mode = BlockEventSeparatorMod.getServerSeparationMode();
        source.method_9226(() -> {
            if (mode == SeparationMode.OFF) {
                return class_2561.method_43470((String)"Block event separation is currently disabled");
            }
            return class_2561.method_43470((String)"").method_27693("Block event separation is currently running in [").method_10852((class_2561)class_2561.method_43470((String)mode.name).method_27694(style -> style.method_27706(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)mode.description))))).method_27693("] mode");
        }, false);
        return 1;
    }

    private static int setMode(class_2168 source, String name) throws CommandSyntaxException {
        SeparationMode mode = SeparationMode.fromName(name);
        if (mode == null) {
            throw ERROR_INVALID_NAME.create();
        }
        BlockEventSeparatorMod.setServerSeparationMode(mode);
        source.method_9226(() -> {
            if (mode == SeparationMode.OFF) {
                return class_2561.method_43470((String)"Disabled block event separation");
            }
            return class_2561.method_43470((String)"").method_27693("Enabled block event separation in [").method_10852((class_2561)class_2561.method_43470((String)mode.name).method_27694(style -> style.method_27706(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)mode.description))))).method_27693("] mode");
        }, true);
        return 1;
    }

    private static int queryInterval(class_2168 source) {
        int interval = BlockEventSeparatorMod.getServerSeparationInterval();
        source.method_9226(() -> class_2561.method_43470((String)String.format("The separation interval is currently set to %s", interval)), false);
        return 1;
    }

    private static int setInterval(class_2168 source, int interval) {
        BlockEventSeparatorMod.setServerSeparationInterval(interval);
        source.method_9226(() -> class_2561.method_43470((String)String.format("Set the separation interval to %s", interval)), true);
        return 1;
    }

    static {
        ERROR_INVALID_NAME = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"That is not a valid mode!"));
        SeparationMode[] modes = SeparationMode.values();
        MODES = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            SeparationMode mode = modes[i];
            BlockEventSeparatorCommand.MODES[mode.index] = mode.name;
        }
    }
}

