/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.cullleaves;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.midnightdust.cullleaves.config.CullLeavesConfig;
import eu.midnightdust.lib.config.MidnightConfig;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="cullleaves")
public class CullLeavesClient {
    public static final String MOD_ID = "cullleaves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cullleaves");
    public static boolean forceLeafCulling = false;
    public static boolean forceHideInnerLeaves = false;

    public static boolean shouldHideBlock(BlockAndTintGetter world, BlockPos pos) {
        if (forceHideInnerLeaves) {
            boolean shouldForceCull = true;
            for (Direction dir : Direction.values()) {
                BlockState otherState = world.m_8055_(pos.m_121945_(dir));
                if (otherState.m_60734_() instanceof LeavesBlock || otherState.m_60783_((BlockGetter)world, pos, dir.m_122424_())) continue;
                shouldForceCull = false;
                break;
            }
            return shouldForceCull;
        }
        return false;
    }

    public static boolean isLeafSideInvisible(BlockState neighborState) {
        if (CullLeavesConfig.enabled || forceLeafCulling) {
            return neighborState.m_60734_() instanceof LeavesBlock;
        }
        return false;
    }

    public static boolean isRootSideInvisible(BlockState neighborState) {
        if (CullLeavesConfig.cullRoots) {
            return neighborState.m_60734_() instanceof MangroveRootsBlock;
        }
        return false;
    }

    public CullLeavesClient() {
        MidnightConfig.init((String)MOD_ID, CullLeavesConfig.class);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, server) -> true));
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> MidnightConfig.getScreen((Screen)parent, (String)MOD_ID)));
    }

    @Mod.EventBusSubscriber(modid="cullleaves", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class CullLeavesClientEvents {
        @SubscribeEvent
        public static void addPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                CullLeavesClientEvents.registerResourcePack(event, new ResourceLocation(CullLeavesClient.MOD_ID, "smartleaves"), false);
            }
        }

        private static void registerResourcePack(AddPackFindersEvent event, ResourceLocation id, boolean alwaysEnabled) {
            event.addRepositorySource(profileAdder -> {
                IModFile file = ModList.get().getModFileById(id.m_135827_()).getFile();
                try (PathPackResources pack = new PathPackResources(id.toString(), true, file.findResource(new String[]{"resourcepacks/" + id.m_135815_()}));){
                    profileAdder.accept(Pack.m_245429_((String)id.toString(), (Component)Component.m_237113_((String)(id.m_135827_() + "/" + id.m_135815_())), (boolean)alwaysEnabled, a -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void m_6213_(ResourceManager manager) {
            forceLeafCulling = false;
            forceHideInnerLeaves = false;
            manager.m_214159_("options", path -> path.toString().startsWith(CullLeavesClient.MOD_ID) && path.toString().endsWith("options.json")).forEach((id, resource) -> {
                try {
                    JsonObject json = JsonParser.parseReader((Reader)resource.m_215508_()).getAsJsonObject();
                    if (json.has("forceLeafCulling")) {
                        forceLeafCulling = json.get("forceLeafCulling").getAsBoolean();
                        LOGGER.info("Forcing leaf culling as requested by resourcepack");
                    }
                    if (json.has("forceHideInnerLeaves")) {
                        forceHideInnerLeaves = json.get("forceHideInnerLeaves").getAsBoolean();
                        LOGGER.info("Not rendering inner leaves as requested by resourcepack");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

