/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.cullleaves;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.midnightdust.cullleaves.config.CullLeavesConfig;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CullLeavesClient {
    public static final String MOD_ID = "cullleaves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cullleaves");
    public static boolean forceLeafCulling = false;
    public static boolean forceHideInnerLeaves = false;

    public static boolean shouldHideBlock(BlockGetter world, BlockPos pos) {
        if (forceHideInnerLeaves) {
            boolean shouldForceCull = true;
            for (Direction dir : Direction.values()) {
                BlockState otherState = world.getBlockState(pos.relative(dir));
                if (otherState.getBlock() instanceof LeavesBlock || otherState.isFaceSturdy(world, pos, dir.getOpposite())) continue;
                shouldForceCull = false;
                break;
            }
            return shouldForceCull;
        }
        return false;
    }

    public static boolean isLeafSideInvisible(BlockState neighborState) {
        if (CullLeavesConfig.enabled || forceLeafCulling) {
            return neighborState.getBlock() instanceof LeavesBlock;
        }
        return false;
    }

    public static boolean isRootSideInvisible(BlockState neighborState) {
        if (CullLeavesConfig.cullRoots) {
            return neighborState.getBlock() instanceof MangroveRootsBlock;
        }
        return false;
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void onResourceManagerReload(ResourceManager manager) {
            forceLeafCulling = false;
            forceHideInnerLeaves = false;
            manager.listResources("options", path -> path.toString().startsWith(CullLeavesClient.MOD_ID) && path.toString().endsWith("options.json")).forEach((id, resource) -> {
                try {
                    JsonObject json = JsonParser.parseReader((Reader)resource.openAsReader()).getAsJsonObject();
                    if (json.has("forceLeafCulling")) {
                        forceLeafCulling = json.get("forceLeafCulling").getAsBoolean();
                        LOGGER.info("Forcing leaf culling as requested by resourcepack");
                    }
                    if (json.has("forceHideInnerLeaves")) {
                        forceHideInnerLeaves = json.get("forceHideInnerLeaves").getAsBoolean();
                        LOGGER.info("Not rendering inner leaves as requested by resourcepack");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

