/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.gui.util;

import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_563;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_7833;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.util.PlayerCapeModel;
import net.orifu.xplat.Lighting;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class PlayerModelRenderer {
    protected final Object id;
    @Nullable
    protected Skin skin;
    protected final int scale;
    protected float xRot = -5.0f;
    protected float yRot = -30.0f;
    protected boolean showSkin = true;
    protected boolean showCape = true;
    protected boolean showElytra = false;
    protected final class_591<?> wide;
    protected final class_591<?> slim;
    protected final PlayerCapeModel<?> cape;
    protected final class_563<?> elytra;
    protected static final float MODEL_HEIGHT = 2.125f;
    protected static final float MODEL_Y_OFFSET = 0.0625f;
    protected static final float MAX_X_ROT = 50.0f;

    public PlayerModelRenderer(Object id, @Nullable Skin skin, int scale, class_310 client) {
        this.id = id;
        this.skin = skin;
        this.scale = scale;
        class_5599 models = client.method_31974();
        this.wide = new class_591(models.method_32072(class_5602.field_27577), false);
        this.slim = new class_591(models.method_32072(class_5602.field_27581), true);
        this.cape = new PlayerCapeModel(PlayerCapeModel.getLayerDefinition().method_32109());
        this.elytra = new class_563(models.method_32072(class_5602.field_27559));
        this.wide.field_3448 = false;
        this.slim.field_3448 = false;
        this.cape.field_3448 = false;
        this.elytra.field_3448 = false;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public void setCape(@Nullable class_2960 texture) {
        if (this.skin == null) {
            this.skin = Skin.defaultSkins()[0];
        }
        this.skin = this.skin.withCape(texture);
    }

    public void showSkin(boolean showSkin) {
        this.showSkin = showSkin;
    }

    public void showCape(boolean showCape) {
        this.showCape = showCape;
    }

    public void showElytra(boolean showElytra) {
        this.showElytra = showElytra;
    }

    public void setXRot(float xRot) {
        this.xRot = class_3532.method_15363((float)xRot, (float)-50.0f, (float)50.0f);
    }

    public void setYRot(float yRot) {
        this.yRot = yRot;
    }

    public void turn(float angle) {
        this.setYRot(this.yRot + angle);
    }

    public void setRotation(float xRot, float yRot) {
        this.setXRot(xRot);
        this.setYRot(yRot);
    }

    public int width() {
        return 16 * this.scale;
    }

    public int height() {
        return 32 * this.scale;
    }

    public void spin(float delta) {
        this.setYRot(this.yRot + delta * 4.0f);
    }

    public void drag(float deltaX, float deltaY) {
        this.setRotation(this.xRot - deltaY * 2.5f, this.yRot + deltaX * 2.5f);
    }

    public void draw(class_332 graphics, int x, int y) {
        if (this.skin == null) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904((double)x + (double)this.width() / 2.0, (double)(y + this.height()), 100.0);
        float scale = (float)this.height() / 2.125f;
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51448().method_46416(0.0f, -0.0625f, 0.0f);
        graphics.method_51448().method_49278(class_7833.field_40714.rotationDegrees(this.xRot), 0.0f, -1.0625f, 0.0f);
        graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(this.yRot));
        graphics.method_51452();
        Lighting.method_56819((Quaternionf)class_7833.field_40714.rotationDegrees(this.xRot));
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(1.0f, 1.0f, -1.0f);
        graphics.method_51448().method_22904(0.0, -1.5, 0.0);
        this.render(graphics);
        graphics.method_51448().method_22909();
        graphics.method_51452();
        Lighting.method_24211();
        graphics.method_51448().method_22909();
    }

    protected void render(class_332 graphics) {
        class_2960 cape;
        class_591<?> model;
        class_591<?> class_5912 = model = this.skin.model().equals((Object)Skin.Model.WIDE) ? this.wide : this.slim;
        if (this.showSkin) {
            class_1921 type = model.method_23500(this.skin.texture());
            PlayerModelRenderer.renderModel(model, type, graphics);
        }
        if ((cape = this.skin.capeTexture()) != null && this.showCape && !this.showElytra) {
            class_1921 capeType = this.cape.method_23500(cape);
            PlayerModelRenderer.renderModel(this.cape, capeType, graphics);
        } else if (this.showElytra) {
            class_2960 elytra = Optional.ofNullable(this.skin.elytraTexture()).or(() -> Optional.ofNullable(this.skin.capeTexture())).orElse(Mod.defaultId("textures/entity/elytra.png"));
            class_1921 elytraType = model.method_23500(elytra);
            PlayerModelRenderer.renderModel(this.elytra, elytraType, graphics);
        }
    }

    private static void renderModel(class_583<?> model, class_1921 type, class_332 graphics) {
        model.method_2828(graphics.method_51448(), graphics.method_51450().getBuffer(type), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

