/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.override;

import com.google.common.base.Suppliers;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.TextureHelper;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public class LocalSkinOverrider
implements OverrideManager.Overrider {
    @Override
    public String fileName(Profile profile, Skin.Model model) {
        return profile.stableId() + "." + model.toString().toLowerCase() + ".png";
    }

    @Override
    public Optional<OverrideManager.Override> get(File file, String name, String ext) {
        if (name.contains(".")) {
            String[] parts = name.split("\\.", 2);
            Skin.Model maybeModel = Skin.Model.tryParse(parts[1]);
            if (ext.equals("png") && maybeModel != null) {
                String hash = Util.hashFile(file);
                return Optional.of(new LocalSkinOverride(parts[0].toLowerCase(Locale.ROOT), file, hash, maybeModel));
            }
        } else if (ext.equals("png")) {
            String hash = Util.hashFile(file);
            return Optional.of(new LocalSkinOverride(name.toLowerCase(Locale.ROOT), file, hash, Skin.Model.WIDE));
        }
        return Optional.empty();
    }

    public record LocalSkinOverride(String playerIdent, File file, String texHash, Skin.Model model, Supplier<class_2960> memoizedTexture) implements OverrideManager.Override
    {
        public LocalSkinOverride(String playerIdent, File file, String texHash, Skin.Model model) {
            this(playerIdent, file, texHash, model, (Supplier<class_2960>)Suppliers.memoize(() -> TextureHelper.skin().location("skin/local/" + texHash).path(file).register().orElseThrow()));
        }

        @Override
        public class_2960 texture() {
            return this.memoizedTexture.get();
        }

        @Override
        @Nullable
        public File texturePath() {
            return this.file;
        }

        @Override
        public class_2561 info() {
            return class_2561.method_43471((String)"skin_overrides.override.local_image");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalSkinOverride)) {
                return false;
            }
            LocalSkinOverride that = (LocalSkinOverride)o;
            return this.model == that.model && Objects.equals(this.playerIdent, that.playerIdent) && Objects.equals(this.texHash, that.texHash);
        }
    }
}

