/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.TextureHelper;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public record Skin(class_2960 texture, @Nullable class_2960 capeTexture, @Nullable class_2960 elytraTexture, Model model) {
    public static final Skin DEFAULT_SKIN = new Skin();

    public Skin() {
        this(Skin.defaultSkinTexture(), null, null, Model.WIDE);
    }

    public static Skin fromProfile(FullProfile profile) {
        class_1071 manager = class_310.method_1551().method_1582();
        return ((CompletableFuture)manager.method_52863(profile.game()).thenApply(sk -> sk.map(Skin::fromPlayerSkin).orElse(DEFAULT_SKIN))).getNow(DEFAULT_SKIN);
    }

    public static class_2960 defaultSkinTexture() {
        return class_1068.method_4649();
    }

    public static Skin[] defaultSkins() {
        return (Skin[])Arrays.stream(class_1068.field_41121).map(Skin::fromPlayerSkin).toArray(Skin[]::new);
    }

    public static CompletableFuture<Optional<DownloadResult>> download(FullProfile profile, boolean skin) {
        return CompletableFuture.supplyAsync(() -> {
            MinecraftProfileTexture mcTexture;
            MinecraftSessionService sessionService = class_310.method_1551().method_1495();
            Property property = sessionService.getPackedTextures(profile.game());
            if (property == null) {
                return Optional.empty();
            }
            MinecraftProfileTextures textures = sessionService.unpackTextures(property);
            MinecraftProfileTexture minecraftProfileTexture = mcTexture = skin ? textures.skin() : textures.cape();
            if (mcTexture == null) {
                return Optional.empty();
            }
            Optional<class_1011> image = TextureHelper.skin().url(mcTexture.getUrl()).image();
            Model model = Model.parse(mcTexture.getMetadata("model"));
            return image.map(img -> new DownloadResult((class_1011)img, model));
        });
    }

    public static CompletableFuture<Skin> fetchSkin(FullProfile profile) {
        class_1071 manager = class_310.method_1551().method_1582();
        return manager.method_52863(profile.game()).thenApply(s -> Skin.fromPlayerSkin(s, (Profile)profile));
    }

    public Skin withSkin(class_2960 skin, Model model) {
        return new Skin(skin, this.capeTexture, this.elytraTexture, model);
    }

    public Skin withCape(@Nullable class_2960 cape) {
        return new Skin(this.texture, cape, null, this.model);
    }

    public Skin withDefaultCape(FullProfile profile) {
        if (profile.properties().containsKey((Object)"skin_overrides-default_textures")) {
            class_1071 manager = class_310.method_1551().method_1582();
            Property property = (Property)profile.properties().get((Object)"skin_overrides-default_textures").stream().findFirst().orElseThrow();
            CompletableFuture skinFuture = (CompletableFuture)manager.field_45634.getUnchecked((Object)new class_1071.class_8686(profile.uuid(), property));
            return Optional.ofNullable((Optional)Util.tryGet(skinFuture)).map(sk -> this.withCape(Skin.fromPlayerSkin(sk.orElse(null), (Profile)profile).capeTexture())).orElse(this);
        }
        return this;
    }

    public static Skin fromPlayerSkin(class_8685 skin) {
        return new Skin(skin.comp_1626(), skin.comp_1627(), skin.comp_1628(), Model.from(skin.comp_1629()));
    }

    public static Skin fromPlayerSkin(class_8685 skin, Profile profile) {
        return Skin.fromPlayerSkin(skin);
    }

    public static Skin fromPlayerSkin(Optional<class_8685> skin, Profile profile) {
        return Skin.fromPlayerSkin(skin.orElseGet(() -> class_1068.method_4648((UUID)profile.uuid())));
    }

    public class_8685 toPlayerSkin() {
        return new class_8685(this.texture, null, this.capeTexture, this.elytraTexture, this.model.toPlayerSkinModel(), false);
    }

    public static enum Model {
        WIDE("wide", "classic"),
        SLIM("slim");

        private final String key;
        public final String apiName;

        private Model(String key) {
            this(key, key);
        }

        private Model(String key, String apiName) {
            this.key = key;
            this.apiName = apiName;
        }

        public static Model parse(@Nullable String key) {
            Model model = Model.tryParse(key);
            return model == null ? WIDE : model;
        }

        @Nullable
        public static Model tryParse(@Nullable String key) {
            if (key == null) {
                return null;
            }
            if ((key = key.toLowerCase(Locale.ROOT)).equals(Model.WIDE.key) || key.equals(Model.WIDE.apiName)) {
                return WIDE;
            }
            if (key.equals(Model.SLIM.key) || key.equals(Model.SLIM.apiName)) {
                return SLIM;
            }
            return null;
        }

        public String id() {
            return this.key;
        }

        public static Model from(class_8685.class_7920 model) {
            return switch (model) {
                default -> throw new IncompatibleClassChangeError();
                case class_8685.class_7920.field_41123 -> WIDE;
                case class_8685.class_7920.field_41122 -> SLIM;
            };
        }

        public class_8685.class_7920 toPlayerSkinModel() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> class_8685.class_7920.field_41123;
                case 1 -> class_8685.class_7920.field_41122;
            };
        }
    }

    public record DownloadResult(class_1011 image, Model model) {
    }

    public record Signature(@Nullable String value, @Nullable String signature) {
        public static Optional<Signature> fromProperty(Property property) {
            return property.signature() != null ? Optional.of(new Signature(property.value(), property.signature())) : Optional.empty();
        }

        public static interface Provider {
            public CompletableFuture<Optional<Signature>> signature();
        }
    }
}

