/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.gui.screen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7065;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.SkinNetworking;
import net.orifu.skin_overrides.gui.screen.OverridesScreen;
import net.orifu.skin_overrides.networking.ModNetworking;
import net.orifu.skin_overrides.override.SkinChangeOverride;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.util.Toast;
import net.orifu.xplat.gui.components.LinearLayout;
import org.jetbrains.annotations.Nullable;

public class SkinChangeInfoScreen
extends class_7065 {
    private static final class_2561 HEADER = class_2561.method_43471((String)"skin_overrides.change_skin.title");
    private static final class_2561 MESSAGE = class_2561.method_43471((String)"skin_overrides.change_skin.message");
    private static final class_2561 MESSAGE_VANILLA = class_2561.method_43471((String)"skin_overrides.change_skin.message.vanilla");
    private static final class_2561 MESSAGE_MODDED = class_2561.method_43471((String)"skin_overrides.change_skin.message.modded");
    private static final String LEARN_MORE_URL = "https://rosebud.dev/skin-overrides/networking/";
    private final OverridesScreen parent;

    protected SkinChangeInfoScreen(OverridesScreen parent) {
        super(HEADER, SkinChangeInfoScreen.getMessage(), SkinChangeInfoScreen.getMessage());
        this.parent = parent;
    }

    protected static class_2561 getMessage() {
        return class_310.method_1551().field_1724 == null ? MESSAGE : (ModNetworking.isOnSkinOverridesServer() ? MESSAGE_MODDED : MESSAGE_VANILLA);
    }

    protected class_8133 method_57750() {
        class_8667 rows = LinearLayout.method_52741().method_52735(8);
        class_8667 buttons = (class_8667)rows.method_52736((class_8021)LinearLayout.method_52742().method_52735(8));
        buttons.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24338, btn -> this.changeSkin()).method_46431());
        buttons.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, btn -> this.method_25419()).method_46431());
        rows.method_52737((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skin_overrides.change_skin.learn_more"), (class_4185.class_4241)class_407.method_49625((class_437)this, (String)LEARN_MORE_URL)).method_46431(), class_7847.method_46481().method_46467());
        return rows;
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parent);
    }

    protected void changeSkin() {
        class_1011 image;
        this.field_22787.method_1507((class_437)this.parent);
        FullProfile userProfile = FullProfile.user();
        Optional<OverrideManager.Override> override = Mod.SKINS.get(userProfile);
        if (override.isEmpty()) {
            Mod.LOGGER.warn("user tried to change skin, but has no override");
            return;
        }
        File texturePath = override.get().texturePath();
        Skin.Model skinModel = override.get().model();
        if (texturePath == null || skinModel == null) {
            Mod.LOGGER.warn("user tried to change skin, but current override has no skin texture path/model");
            return;
        }
        try {
            image = class_1011.method_4309((InputStream)new FileInputStream(texturePath));
        }
        catch (IOException e) {
            Mod.LOGGER.error("failed to read skin texture", (Throwable)e);
            return;
        }
        Mod.LOGGER.debug("got image and model; now trying to change skin");
        CompletableFuture.supplyAsync(() -> SkinNetworking.setUserSkin(image, skinModel)).thenAccept(newSkinUrl -> this.handleSkinChange(newSkinUrl.orElse(null), userProfile, skinModel));
    }

    protected void handleSkinChange(@Nullable String newSkinUrl, FullProfile userProfile, Skin.Model model) {
        if (newSkinUrl != null) {
            Mod.LOGGER.debug("player has changed skin. new url: {}", (Object)newSkinUrl);
            Mod.SKINS.removeOverride(userProfile);
            this.parent.markDirty();
            CompletableFuture.runAsync(() -> SkinChangeOverride.set(newSkinUrl, model), (Executor)class_310.method_1551());
            if (!ModNetworking.isOnSkinOverridesServer()) {
                return;
            }
            CompletableFuture<Optional<FullProfile>> updatedProfile = FullProfile.fetchExpectingSkinUrl(userProfile.uuid(), newSkinUrl);
            updatedProfile.thenAccept(profile -> {
                if (profile.isPresent()) {
                    Skin.Signature signedSkin = ((FullProfile)profile.get()).skinSignature();
                    Mod.LOGGER.debug("received updated profile from services:\nval: {}\nsig: {}", (Object)signedSkin.value(), (Object)signedSkin.signature());
                    ModNetworking.updateSkinOnServer(signedSkin.value(), signedSkin.signature());
                } else {
                    Toast.show((class_2561)class_2561.method_43471((String)"skin_overrides.change_skin.reload_fail.title"), (class_2561)class_2561.method_43471((String)"skin_overrides.change_skin.reload_fail.description"));
                }
            });
        } else {
            Toast.show((class_2561)class_2561.method_43471((String)"skin_overrides.change_skin.fail.title"), (class_2561)class_2561.method_43471((String)"skin_overrides.change_skin.fail.description"));
        }
    }
}

