/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.override;

import com.google.common.base.Suppliers;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.TextureHelper;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public class LocalCapeOverrider
implements OverrideManager.Overrider {
    @Override
    public String fileName(Profile profile, @Nullable Skin.Model model) {
        return profile.stableId() + ".png";
    }

    @Override
    public Optional<OverrideManager.Override> get(File file, String name, String ext) {
        if (ext.equals("png")) {
            String hash = Util.hashFile(file);
            return Optional.of(new LocalCapeOverride(name.toLowerCase(Locale.ROOT), file, hash));
        }
        return Optional.empty();
    }

    public record LocalCapeOverride(String playerIdent, File file, String texHash, Supplier<class_2960> memoizedTexture) implements OverrideManager.Override
    {
        public LocalCapeOverride(String playerIdent, File file, String texHash) {
            this(playerIdent, file, texHash, (Supplier<class_2960>)Suppliers.memoize(() -> TextureHelper.cape().id("cape/local/" + texHash).path(file).register().orElseThrow()));
        }

        @Override
        public class_2960 texture() {
            return this.memoizedTexture.get();
        }

        @Override
        public File texturePath() {
            return this.file;
        }

        @Override
        public class_2561 info() {
            return class_2561.method_43471((String)"skin_overrides.override.local_image");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalCapeOverride)) {
                return false;
            }
            LocalCapeOverride that = (LocalCapeOverride)o;
            return Objects.equals(this.texHash, that.texHash) && Objects.equals(this.playerIdent, that.playerIdent);
        }
    }
}

