/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.profile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11755;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.Util;

public record FullProfile(String name, UUID uuid, PropertyMap properties) implements Profile
{
    public FullProfile(GameProfile profile) {
        this(profile.name(), profile.id(), profile.properties());
    }

    public static FullProfile user() {
        return new FullProfile(class_310.method_1551().method_53462());
    }

    public static CompletableFuture<Optional<FullProfile>> fetch(String nameOrUuid) {
        CompletableFuture<Optional<FullProfile>> future = new CompletableFuture<Optional<FullProfile>>();
        Util.ioPool().execute(() -> future.complete(FullProfile.fetchSync(nameOrUuid)));
        return future;
    }

    public static Optional<FullProfile> fetchSync(String nameOrUuid) {
        class_11755 resolver = class_310.method_1551().method_73361().comp_4624();
        return Util.asUuid(nameOrUuid).map(arg_0 -> ((class_11755)resolver).method_73290(arg_0)).orElseGet(() -> resolver.method_73289(nameOrUuid)).map(FullProfile::new);
    }

    public static Optional<FullProfile> fetchSync(UUID uuid) {
        class_11755 resolver = class_310.method_1551().method_73361().comp_4624();
        return resolver.method_73290(uuid).map(FullProfile::new);
    }

    public static CompletableFuture<Optional<FullProfile>> fetchExpectingSkinUrl(UUID uuid, String skinUrl) {
        return CompletableFuture.supplyAsync(() -> {
            for (int tries = 0; tries < 4; ++tries) {
                Optional<FullProfile> profile = FullProfile.fetchSync(uuid);
                if (profile.isEmpty()) continue;
                String receivedUrl = profile.get().skinUrl();
                if (receivedUrl.equals(skinUrl)) {
                    return profile;
                }
                Mod.LOGGER.debug("expected and received skin urls:\n{}\n{}", (Object)skinUrl, (Object)receivedUrl);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    public GameProfile game() {
        return new GameProfile(this.uuid, this.name, this.properties);
    }

    @Override
    public Optional<FullProfile> upgradeSync() {
        return Optional.of(this);
    }

    private Property packedTextures() {
        return Objects.requireNonNull(class_310.method_1551().method_73361().comp_837().getPackedTextures(this.game()));
    }

    public String skinUrl() {
        return Objects.requireNonNull(class_310.method_1551().method_73361().comp_837().unpackTextures(this.packedTextures()).skin()).getUrl();
    }

    public Skin.Signature skinSignature() {
        Property packed = this.packedTextures();
        return new Skin.Signature(packed.value(), packed.signature());
    }

    @Override
    public boolean equals(Object obj) {
        Profile profile;
        return obj instanceof Profile && this.sameUserAs(profile = (Profile)obj);
    }
}

