/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10538;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public class TextureHelper {
    public static SourceBuilder skin() {
        return new SourceBuilder(TextureType.SKIN);
    }

    public static SourceBuilder cape() {
        return new SourceBuilder(TextureType.CAPE);
    }

    public static class_2960 registerGenericTexture(class_2960 location, class_1044 texture) {
        if (class_310.method_1551().method_1531().field_5286.containsKey(location)) {
            return location;
        }
        class_310.method_1551().method_1531().method_4616(location, texture);
        return location;
    }

    public static Optional<class_2960> registerPlayerTexture(class_1011 image, class_2960 location, boolean isSkin) {
        Optional<class_1011> maybeImage = isSkin ? TextureHelper.processLegacySkin(image, location) : Optional.of(image);
        return maybeImage.flatMap(updatedImage -> {
            try {
                class_10538 SkinTextureDownloader = class_310.method_1551().method_1582().field_62487;
                SkinTextureDownloader.method_65860(TextureHelper.dummy(location), updatedImage).get();
                return Optional.of(location);
            }
            catch (InterruptedException | ExecutionException exception) {
                return Optional.empty();
            }
        });
    }

    public static Optional<class_1011> processLegacySkin(class_1011 image, class_2960 location) {
        try {
            return Optional.of(class_10538.method_65863((class_1011)image, (String)location.toString()));
        }
        catch (IllegalStateException ignored) {
            return Optional.empty();
        }
    }

    public static Optional<class_1011> downloadTexture(String url, Path cachePath) {
        try {
            class_10538 SkinTextureDownloader = class_310.method_1551().method_1582().field_62487;
            class_1011 image = SkinTextureDownloader.method_65865(cachePath, url);
            return Optional.of(image);
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    public static class_12079.class_12081 dummy(class_2960 texturePath) {
        return new DummyClientTexture(texturePath);
    }

    public static class SourceBuilder {
        private final TextureType type;
        @Nullable
        private class_2960 location;
        @Nullable
        private String url;
        @Nullable
        private Path path;

        public SourceBuilder(TextureType type) {
            this.type = type;
        }

        public SourceBuilder location(class_2960 location) {
            this.location = location;
            return this;
        }

        public SourceBuilder location(String location) {
            this.location = Mod.res(location);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return new Builder(this);
        }

        public Builder path(Path path) {
            this.path = path;
            return new Builder(this);
        }

        public Builder path(File file) {
            this.path = file.toPath();
            return new Builder(this);
        }
    }

    public static enum TextureType {
        SKIN,
        CAPE,
        GENERIC;

    }

    public static final class DummyClientTexture
    extends Record
    implements class_12079.class_12081 {
        private final class_2960 texturePath;

        public DummyClientTexture(class_2960 texturePath) {
            this.texturePath = texturePath;
        }

        public class_2960 comp_3626() {
            return this.texturePath;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DummyClientTexture.class, "texturePath", "texturePath"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DummyClientTexture.class, "texturePath", "texturePath"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DummyClientTexture.class, "texturePath", "texturePath"}, this, o);
        }

        public class_2960 comp_3627() {
            return this.texturePath;
        }
    }

    public static class Builder {
        private final SourceBuilder builder;
        private final class_2960 location;
        private final Path path;

        public Builder(SourceBuilder builder) {
            this.builder = builder;
            this.location = builder.location == null ? Mod.res("temp/" + Util.randomId()) : builder.location;
            this.path = builder.path != null ? builder.path : Util.nameTempFile().orElseThrow().toPath();
        }

        public Optional<Path> path() {
            if (this.path.toFile().isFile()) {
                return Optional.of(this.path);
            }
            return Optional.empty();
        }

        public Optional<class_1011> image() {
            if (this.builder.url != null) {
                return TextureHelper.downloadTexture(this.builder.url, this.path);
            }
            if (this.builder.path != null) {
                RenderSystem.assertOnRenderThread();
                try {
                    if (this.builder.path.toFile().isFile()) {
                        InputStream stream = Files.newInputStream(this.builder.path, new OpenOption[0]);
                        class_1011 image = class_1011.method_4309((InputStream)stream);
                        return Optional.of(image);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        }

        public Optional<class_1044> texture() {
            if (this.builder.type.equals((Object)TextureType.GENERIC)) {
                return this.image().map(image -> new class_1043(() -> ((class_2960)this.location).toString(), image));
            }
            return Optional.empty();
        }

        public Optional<class_2960> register() {
            return switch (this.builder.type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.image().flatMap(image -> TextureHelper.registerPlayerTexture(image, this.location, true));
                case 1 -> this.image().flatMap(image -> TextureHelper.registerPlayerTexture(image, this.location, false));
                case 2 -> this.texture().map(tex -> TextureHelper.registerGenericTexture(this.location, tex));
            };
        }
    }
}

