/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import com.google.gson.JsonElement;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.override.LibraryOverrider;
import org.jetbrains.annotations.Nullable;

public interface Library {
    public List<LibraryEntry> entries();

    public void save();

    public void reload();

    public LibraryOverrider overrider();

    default public Optional<LibraryEntry> get(String id) {
        for (LibraryEntry entry : this.entries()) {
            if (!entry.getId().equals(id)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    default public void add(LibraryEntry entry) {
        this.entries().add(0, entry);
        this.save();
    }

    default public boolean replace(LibraryEntry from, LibraryEntry to) {
        for (int i = 0; i < this.entries().size(); ++i) {
            LibraryEntry entry = this.entries().get(i);
            if (!entry.getId().equals(from.getId())) continue;
            if (!from.getId().equals(to.getId())) {
                from.removeFiles();
            }
            this.entries().remove(i);
            this.entries().add(i, to);
            this.save();
            return true;
        }
        return false;
    }

    default public void remove(int index) {
        this.entries().remove(index).removeFiles();
        this.save();
    }

    default public void move(int i, int j) {
        this.entries().add(j, this.entries().remove(i));
        this.save();
    }

    default public void rename(LibraryEntry entry, String newName) {
        this.get(entry.id).ifPresent(internalEntry -> {
            entry.name = internalEntry.name = newName;
            this.save();
        });
        if (!entry.name.equals(newName)) {
            Mod.LOGGER.error("you encountered a rare bug! please report this on our issue tracker.");
        }
    }

    public static abstract class LibraryEntry {
        protected String name;
        protected String id;

        public LibraryEntry(String name, String id) {
            this.name = name;
            this.id = id.toLowerCase(Locale.ROOT);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public abstract class_2960 getTexture();

        @Nullable
        public abstract File texturePath();

        public abstract JsonElement toJson();

        public abstract void removeFiles();

        public boolean equals(Object o) {
            if (!(o instanceof LibraryEntry)) {
                return false;
            }
            LibraryEntry that = (LibraryEntry)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id);
        }
    }
}

