/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.profile;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.PartialProfile;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.Util;

public record FullProfile(String name, UUID uuid, PropertyMap properties) implements Profile
{
    private static FullProfile cachedUserProfile;

    public FullProfile(GameProfile profile) {
        this(profile.getName(), profile.getId(), profile.getProperties());
    }

    public static FullProfile user() {
        if (cachedUserProfile != null) {
            return cachedUserProfile;
        }
        GameProfile gameProfile = class_310.method_1551().method_1548().method_1677();
        gameProfile.getProperties().putAll((Multimap)class_310.method_1551().method_1539());
        cachedUserProfile = new FullProfile(gameProfile);
        return cachedUserProfile;
    }

    public static CompletableFuture<Optional<FullProfile>> fetch(String nameOrUuid) {
        CompletableFuture<Optional<FullProfile>> future = new CompletableFuture<Optional<FullProfile>>();
        class_156.method_27958().execute(() -> future.complete(FullProfile.fetchSync(nameOrUuid)));
        return future;
    }

    public static Optional<FullProfile> fetchSync(String nameOrUuid) {
        Optional<UUID> id = Util.asUuid(nameOrUuid).or(() -> PartialProfile.getProfileCache().method_14515(nameOrUuid).map(GameProfile::getId));
        return id.flatMap(FullProfile::fetchSync);
    }

    public static Optional<FullProfile> fetchSync(UUID uuid) {
        GameProfile result = class_310.method_1551().method_1495().fillProfileProperties(new GameProfile(uuid, null), true);
        return result.getName() == null ? Optional.empty() : Optional.of(new FullProfile(result));
    }

    public static CompletableFuture<Optional<FullProfile>> fetchExpectingSkinUrl(UUID uuid, String skinUrl) {
        return CompletableFuture.supplyAsync(() -> {
            for (int tries = 0; tries < 4; ++tries) {
                Optional<FullProfile> profile = FullProfile.fetchSync(uuid);
                if (profile.isEmpty()) continue;
                String receivedUrl = profile.get().skinUrl();
                if (receivedUrl.equals(skinUrl)) {
                    return profile;
                }
                Mod.LOGGER.debug("expected and received skin urls:\n" + skinUrl + "\n" + receivedUrl);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    public GameProfile game() {
        GameProfile profile = new GameProfile(this.uuid, this.name);
        profile.getProperties().putAll((Multimap)this.properties);
        return profile;
    }

    @Override
    public Optional<FullProfile> upgradeSync() {
        return Optional.of(this);
    }

    private Property packedTextures() {
        return (Property)this.properties().get((Object)"textures").stream().findFirst().orElseThrow();
    }

    public String skinUrl() {
        return ((MinecraftProfileTexture)class_310.method_1551().method_1495().getTextures(this.game(), false).get(MinecraftProfileTexture.Type.SKIN)).getUrl();
    }

    public Skin.Signature skinSignature() {
        Property packed = this.packedTextures();
        return new Skin.Signature(packed.getValue(), packed.getSignature());
    }
}

