/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.networking;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.SkinNetworking;
import net.orifu.skin_overrides.util.Util;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;

public class MineSkin {
    public static CompletableFuture<Optional<Skin.Signature>> sign(class_2960 texture, Skin.Model model) {
        CompletableFuture<class_1011> image = Util.saveTexture(texture, 64, 64);
        return image.thenApplyAsync(img -> MineSkin.sign(img, model));
    }

    public static Optional<Skin.Signature> sign(class_1011 image, Skin.Model model) {
        String body;
        HttpResponse response;
        File skinFile;
        try {
            skinFile = File.createTempFile("skin-overrides_", "_temp-skin");
            image.method_4325(skinFile);
            image.close();
        }
        catch (IOException e) {
            return Optional.empty();
        }
        HttpPost post = new HttpPost("https://api.mineskin.org/v2/generate");
        post.setHeader("User-Agent", "skin-overrides/2.4.0-beta.1 (github/rosebudmods)");
        post.setEntity(MultipartEntityBuilder.create().addTextBody("variant", model.apiName).addTextBody("visibility", "unlisted").addBinaryBody("file", skinFile, ContentType.IMAGE_PNG, "skin.png").build());
        try {
            response = SkinNetworking.HTTP_CLIENT.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (IOException e) {
            return Optional.empty();
        }
        if (response.getStatusLine().getStatusCode() / 100 != 2) {
            Mod.LOGGER.error("failed to sign skin, got API response:\n{}", (Object)body);
            return Optional.empty();
        }
        JsonObject jsonBody = (JsonObject)new Gson().fromJson(body, JsonObject.class);
        Mod.LOGGER.debug("mineskin response: {}", (Object)body);
        if (!jsonBody.get("success").getAsBoolean()) {
            Mod.LOGGER.error("failed to sign skin, got API response:\n{}", (Object)body);
            return Optional.empty();
        }
        JsonObject skinInfo = jsonBody.getAsJsonObject("skin").getAsJsonObject("texture").getAsJsonObject("data");
        String skinValue = skinInfo.get("value").getAsString();
        String skinSignature = skinInfo.get("signature").getAsString();
        return Optional.of(new Skin.Signature(skinValue, skinSignature));
    }
}

