/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.gui.components;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_640;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.gui.components.OverrideListEntry;
import net.orifu.skin_overrides.gui.screen.OverridesScreen;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.profile.PartialProfile;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.xplat.gui.components.ObjectSelectionList;

public class OverridesSelectionList
extends ObjectSelectionList<OverrideListEntry> {
    private static final int PADDING = 8;
    private static final int ITEM_HEIGHT = 36;
    private final OverridesScreen parent;
    public final OverrideManager ov;
    private final ArrayList<OverrideListEntry> allEntries = new ArrayList();
    @Nullable
    private Profile lastSelected = null;
    private String query = "";
    private final ArrayList<CompletableFuture<PartialProfile>> loadingProfiles;

    public OverridesSelectionList(OverridesScreen parent, OverrideManager ov) {
        super(class_310.method_1551(), 0, 0, 0, 36);
        this.parent = parent;
        this.ov = ov;
        FullProfile localPlayer = FullProfile.user();
        this.tryAddProfile(localPlayer, OverrideListEntry.Type.USER);
        if (this.field_22740.field_1724 != null) {
            for (class_640 player : this.field_22740.field_1724.field_3944.method_2880()) {
                this.tryAddProfile(new FullProfile(player.method_2966()), OverrideListEntry.Type.ONLINE);
            }
        }
        this.updateList();
        this.loadingProfiles = new ArrayList<CompletableFuture<PartialProfile>>(this.ov.profilesWithOverride());
    }

    public void tick() {
        this.loadingProfiles.removeIf(futureProfile -> {
            if (futureProfile.isDone()) {
                this.tryAddProfile(futureProfile.getNow(null), OverrideListEntry.Type.OFFLINE);
                this.updateList();
                return true;
            }
            return false;
        });
    }

    protected void tryAddProfile(Profile profile, OverrideListEntry.Type type) {
        if (!this.hasOverrideFor(profile) || type.equals((Object)OverrideListEntry.Type.USER)) {
            this.allEntries.add(new OverrideListEntry(this.field_22740, profile, type, this.parent));
        }
    }

    public OverrideListEntry addProfile(Profile profile) {
        return this.getOverrideFor(profile).orElseGet(() -> {
            OverrideListEntry entry = new OverrideListEntry(this.field_22740, profile, OverrideListEntry.Type.OFFLINE, this.parent);
            this.allEntries.add(entry);
            this.updateList();
            return entry;
        });
    }

    public boolean hasOverrideFor(Profile profile) {
        return this.getOverrideFor(profile).isPresent();
    }

    protected Optional<OverrideListEntry> getOverrideFor(Profile profile) {
        if (!this.allEntries.isEmpty() && FullProfile.user().name().equalsIgnoreCase(profile.name())) {
            return Optional.of(this.allEntries.get(0));
        }
        for (OverrideListEntry player : this.allEntries) {
            if (!player.profile.equals(profile)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public void filter(String query) {
        this.query = query.toLowerCase();
        this.updateList();
    }

    public void updateList() {
        OverrideListEntry selected = (OverrideListEntry)this.method_25334();
        if (selected != null) {
            this.lastSelected = selected.profile;
        }
        this.method_25339();
        for (OverrideListEntry entry : this.allEntries) {
            if (!entry.profile.name().toLowerCase().contains(this.query)) continue;
            this.method_25321((class_350.class_351)entry);
            if (!entry.profile.equals(this.lastSelected)) continue;
            this.method_25313((class_350.class_351)entry);
        }
    }

    public int method_25322() {
        return Math.min(this.field_22758 - 16, 220);
    }

    protected int method_65507() {
        return this.method_55442() - 6;
    }

    public int method_25337(int index) {
        return super.method_25337(index) - 4 + 8;
    }
}

