/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.gui.util;

import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.gui.GuiGraphicsExt;
import net.orifu.skin_overrides.gui.pip.GuiModelPreviewRenderer;
import org.jetbrains.annotations.Nullable;

public class PlayerModelRenderer {
    protected final Object id;
    @Nullable
    protected Skin skin;
    protected final int scale;
    protected float xRot = -5.0f;
    protected float yRot = -30.0f;
    protected boolean showSkin = true;
    protected boolean showCape = true;
    protected boolean showElytra = false;
    protected static final float MODEL_HEIGHT = 2.125f;
    protected static final float MODEL_Y_OFFSET = 0.0625f;
    protected static final float MAX_X_ROT = 50.0f;

    public PlayerModelRenderer(Object id, @Nullable Skin skin, int scale) {
        this.id = id;
        this.skin = skin;
        this.scale = scale;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public void setCape(@Nullable class_2960 texture) {
        if (this.skin == null) {
            this.skin = Skin.defaultSkins()[0];
        }
        this.skin = this.skin.withCape(texture);
    }

    public void showSkin(boolean showSkin) {
        this.showSkin = showSkin;
    }

    public void showCape(boolean showCape) {
        this.showCape = showCape;
    }

    public void showElytra(boolean showElytra) {
        this.showElytra = showElytra;
    }

    public void setXRot(float xRot) {
        this.xRot = class_3532.method_15363((float)xRot, (float)-50.0f, (float)50.0f);
    }

    public void setYRot(float yRot) {
        this.yRot = yRot;
    }

    public void turn(float angle) {
        this.setYRot(this.yRot + angle);
    }

    public void setRotation(float xRot, float yRot) {
        this.setXRot(xRot);
        this.setYRot(yRot);
    }

    public int width() {
        return 16 * this.scale;
    }

    public int height() {
        return 32 * this.scale;
    }

    public void spin(float delta) {
        this.setYRot(this.yRot + delta * 4.0f);
    }

    public void drag(float deltaX, float deltaY) {
        this.setRotation(this.xRot - deltaY * 2.5f, this.yRot + deltaX * 2.5f);
    }

    public void draw(class_332 graphics, int x, int y) {
        if (this.skin == null) {
            return;
        }
        Function<class_8030, GuiModelPreviewRenderer.GuiModelPreviewRenderState> state = GuiModelPreviewRenderer.GuiModelPreviewRenderState.create(x, y, this.width(), this.height(), this.xRot, this.yRot, (float)this.height() / 2.125f, -1.0625f, this.showSkin, this.showCape, this.showElytra, this.skin);
        ((GuiGraphicsExt)graphics).addMultiplePipRenderer(this.id, GuiModelPreviewRenderer::new, state);
    }
}

