/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.profile;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.PartialProfile;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.Util;

public record FullProfile(String name, UUID uuid, PropertyMap properties) implements Profile
{
    public FullProfile(GameProfile profile) {
        this(profile.getName(), profile.getId(), profile.getProperties());
    }

    public static FullProfile user() {
        return new FullProfile(class_310.method_1551().method_53462());
    }

    public static CompletableFuture<Optional<FullProfile>> fetch(String nameOrUuid) {
        CompletableFuture<Optional<FullProfile>> future = new CompletableFuture<Optional<FullProfile>>();
        class_156.method_55473().execute(() -> future.complete(FullProfile.fetchSync(nameOrUuid)));
        return future;
    }

    public static Optional<FullProfile> fetchSync(String nameOrUuid) {
        Optional<UUID> id = Util.asUuid(nameOrUuid).or(() -> PartialProfile.getProfileCache().method_14515(nameOrUuid).map(GameProfile::getId));
        return id.flatMap(FullProfile::fetchSync);
    }

    public static Optional<FullProfile> fetchSync(UUID uuid) {
        ProfileResult result = class_310.method_1551().method_1495().fetchProfile(uuid, true);
        return Optional.ofNullable(result).map(r -> new FullProfile(r.profile()));
    }

    public static CompletableFuture<Optional<FullProfile>> fetchExpectingSkinUrl(UUID uuid, String skinUrl) {
        return CompletableFuture.supplyAsync(() -> {
            for (int tries = 0; tries < 4; ++tries) {
                Optional<FullProfile> profile = FullProfile.fetchSync(uuid);
                if (profile.isEmpty()) continue;
                String receivedUrl = profile.get().skinUrl();
                if (receivedUrl.equals(skinUrl)) {
                    return profile;
                }
                Mod.LOGGER.debug("expected and received skin urls:\n" + skinUrl + "\n" + receivedUrl);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    public GameProfile game() {
        GameProfile profile = new GameProfile(this.uuid, this.name);
        profile.getProperties().putAll((Multimap)this.properties);
        return profile;
    }

    @Override
    public Optional<FullProfile> upgradeSync() {
        return Optional.of(this);
    }

    private Property packedTextures() {
        return class_310.method_1551().method_1495().getPackedTextures(this.game());
    }

    public String skinUrl() {
        return class_310.method_1551().method_1495().unpackTextures(this.packedTextures()).skin().getUrl();
    }

    public Skin.Signature skinSignature() {
        Property packed = this.packedTextures();
        return new Skin.Signature(packed.value(), packed.signature());
    }
}

