/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.mixin.YggdrasilServiceClientAccessor;
import net.orifu.skin_overrides.mixin.YggdrasilUserApiServiceAccessor;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class SkinNetworking {
    public static final HttpClient HTTP_CLIENT = HttpClients.createDefault();

    public static Optional<String> setUserSkin(class_1011 image, Skin.Model model) {
        String body;
        HttpResponse response;
        File skinFile;
        try {
            skinFile = File.createTempFile("skin-overrides_", "_temp-skin");
            image.method_4325(skinFile);
            image.close();
        }
        catch (IOException e) {
            return Optional.empty();
        }
        YggdrasilUserApiService userApiService = (YggdrasilUserApiService)class_310.method_1551().field_26902;
        YggdrasilUserApiServiceAccessor userApiServiceAccessor = (YggdrasilUserApiServiceAccessor)userApiService;
        MinecraftClient serviceClient = userApiServiceAccessor.getMinecraftClient();
        YggdrasilServiceClientAccessor serviceClientAccessor = (YggdrasilServiceClientAccessor)serviceClient;
        String servicesHost = userApiServiceAccessor.getEnvironment().servicesHost();
        String url = servicesHost + "/minecraft/profile/skins";
        HttpPost post = new HttpPost(url);
        post.setHeader("Authorization", "Bearer " + serviceClientAccessor.getAccessToken());
        post.setEntity(MultipartEntityBuilder.create().addTextBody("variant", model.apiName).addBinaryBody("file", skinFile, ContentType.IMAGE_PNG, "skin.png").build());
        try {
            response = HTTP_CLIENT.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (IOException e) {
            return Optional.empty();
        }
        if (response.getStatusLine().getStatusCode() / 100 != 2) {
            Mod.LOGGER.error("failed to sign skin, got API response:\n{}", (Object)body);
            return Optional.empty();
        }
        JsonObject jsonBody = (JsonObject)new Gson().fromJson(body, JsonObject.class);
        Mod.LOGGER.debug("skin server response: {}", (Object)body);
        JsonObject skinInfo = jsonBody.getAsJsonArray("skins").get(0).getAsJsonObject();
        String textureUrl = skinInfo.get("url").getAsString();
        return Optional.of(textureUrl);
    }

    public static Optional<PlayerProfileResponse> getPlayerProfile() {
        boolean isSignedIn = class_310.method_1551().field_26902 instanceof YggdrasilUserApiService;
        if (!isSignedIn) {
            return Optional.empty();
        }
        YggdrasilUserApiService userApiService = (YggdrasilUserApiService)class_310.method_1551().field_26902;
        YggdrasilUserApiServiceAccessor userApiServiceAccessor = (YggdrasilUserApiServiceAccessor)userApiService;
        MinecraftClient serviceClient = userApiServiceAccessor.getMinecraftClient();
        String servicesHost = userApiServiceAccessor.getEnvironment().servicesHost();
        try {
            return Optional.ofNullable((PlayerProfileResponse)serviceClient.get(HttpAuthenticationService.constantURL((String)(servicesHost + "/minecraft/profile")), PlayerProfileResponse.class));
        }
        catch (MinecraftClientHttpException e) {
            Mod.LOGGER.warn("failed to make retrieve list of user's capes");
            return Optional.empty();
        }
    }

    public record PlayerProfileResponse(@SerializedName(value="id") UUID id, @SerializedName(value="name") String name, @SerializedName(value="skins") List<PlayerProfileSkin> skins, @SerializedName(value="capes") List<PlayerProfileCape> capes) {
    }

    public record PlayerProfileCape(@SerializedName(value="id") String id, @SerializedName(value="state") String state, @SerializedName(value="url") String url, @SerializedName(value="alias") String alias) {
    }

    public record PlayerProfileSkin(@SerializedName(value="state") String state, @SerializedName(value="url") String url, @SerializedName(value="variant") String variant) {
    }
}

