/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.library;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.override.LibraryOverrider;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLibrary
implements Library {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected List<Library.LibraryEntry> entries = new ArrayList<Library.LibraryEntry>();
    protected Set<String> knownDuplicateIds = new HashSet<String>();
    protected final String rootFolder;
    protected final File libraryJsonFile;
    protected final File libraryFolder;

    public AbstractLibrary(String rootFolder) {
        this.rootFolder = rootFolder;
        this.libraryJsonFile = new File(rootFolder, "library.json");
        this.libraryFolder = new File(rootFolder, "library");
        if (this.libraryFolder.mkdirs()) {
            Mod.LOGGER.debug("library folder created");
        }
    }

    @Override
    public List<Library.LibraryEntry> entries() {
        return this.entries;
    }

    @Override
    public void save() {
        JsonArray arr = new JsonArray();
        this.entries().forEach(e -> arr.add(e.toJson()));
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.libraryJsonFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(GSON.toJson((JsonElement)arr));
            writer.close();
        }
        catch (IOException e2) {
            Mod.LOGGER.error("failed to save library file {}", (Object)this.libraryJsonFile, (Object)e2);
        }
    }

    @Override
    public void reload() {
        ArrayList<Library.LibraryEntry> newEntries = new ArrayList<Library.LibraryEntry>();
        HashSet<String> newIds = new HashSet<String>();
        HashSet<String> duplicateIds = new HashSet<String>();
        try {
            BufferedReader reader = Files.newBufferedReader(this.libraryJsonFile.toPath(), StandardCharsets.UTF_8);
            JsonArray arr = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
            for (JsonElement el : arr) {
                Optional<Library.LibraryEntry> maybeLoaded = this.tryLoadFromJsonElement(el);
                if (!maybeLoaded.isPresent()) continue;
                Library.LibraryEntry loaded = maybeLoaded.get();
                String id = loaded.getId();
                if (newIds.contains(id)) {
                    if (!this.knownDuplicateIds.contains(id)) {
                        Mod.LOGGER.warn("library entry has duplicate ID `{}`", (Object)id);
                    }
                    duplicateIds.add(id);
                    continue;
                }
                Optional<Library.LibraryEntry> existing = this.entries.stream().filter(ent -> ent.equals(loaded)).findAny();
                newEntries.add(existing.orElse(loaded));
                newIds.add(id);
            }
            reader.close();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.addDefaultEntries();
            this.save();
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            Mod.LOGGER.error("failed to load library file {}", (Object)this.libraryJsonFile, (Object)e);
        }
        this.entries = newEntries;
        this.knownDuplicateIds = duplicateIds;
    }

    @Override
    public LibraryOverrider overrider() {
        return new LibraryOverrider(this, this.rootFolder);
    }

    protected Optional<Library.LibraryEntry> tryLoadFromJsonElement(JsonElement el) {
        if (el.isJsonObject()) {
            JsonObject obj = el.getAsJsonObject();
            Optional<String> name = Util.readString(obj, "name");
            Optional<String> id = Util.readString(obj, "id");
            Optional<String> file = Util.readString(obj, "file");
            Optional<String> texture = Util.readString(obj, "texture");
            if (name.isPresent() && id.isPresent()) {
                Optional<Library.LibraryEntry> maybe;
                class_2960 textureId;
                if (file.isPresent() && texture.isEmpty()) {
                    Optional<Library.LibraryEntry> maybe2 = this.tryLoadFromJson(obj, name.get(), id.get(), new File(this.libraryFolder, file.get()), null);
                    if (maybe2.isPresent()) {
                        return maybe2;
                    }
                } else if (texture.isPresent() && file.isEmpty() && (textureId = class_2960.method_12829((String)texture.get())) != null && (maybe = this.tryLoadFromJson(obj, name.get(), id.get(), null, textureId)).isPresent()) {
                    return maybe;
                }
            }
        }
        Mod.LOGGER.warn("failed to load library entry {}", (Object)el);
        return Optional.empty();
    }

    protected abstract Optional<Library.LibraryEntry> tryLoadFromJson(JsonObject var1, String var2, String var3, @Nullable File var4, @Nullable class_2960 var5);

    protected void addDefaultEntries() {
    }

    public static abstract class AbstractLibraryEntry
    extends Library.LibraryEntry {
        @Nullable
        protected final File file;
        @Nullable
        protected final String fileHash;
        @Nullable
        protected final class_2960 textureId;

        protected AbstractLibraryEntry(String name, String id, @Nullable File file, @Nullable class_2960 textureId) {
            super(name, id);
            this.file = file;
            this.fileHash = file == null ? null : Util.hashFile(file);
            this.textureId = textureId;
        }

        public AbstractLibraryEntry(String name, String id, class_2960 textureId) {
            this(name, id, null, textureId);
        }

        @Override
        public class_2960 getTexture() {
            return this.textureId != null ? this.textureId : this.getTextureFromFile();
        }

        @Override
        @Nullable
        public File texturePath() {
            if (this.file == null) {
                Optional<File> file = Util.nameTempFile();
                if (file.isEmpty()) {
                    return null;
                }
                Util.saveTexture(this.getTexture(), 64, 64, file.get().toPath());
                return file.get();
            }
            return this.file;
        }

        protected abstract class_2960 getTextureFromFile();

        @Override
        public JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", this.name);
            obj.addProperty("id", this.id);
            if (this.file != null) {
                obj.addProperty("file", this.file.getName());
            } else if (this.textureId != null) {
                obj.addProperty("texture", this.textureId.toString());
            }
            return obj;
        }

        @Override
        public void removeFiles() {
            if (this.file != null && !this.file.delete()) {
                Mod.LOGGER.debug("failed to delete library entry files for {}", (Object)this.id);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractLibraryEntry)) {
                return false;
            }
            AbstractLibraryEntry that = (AbstractLibraryEntry)o;
            if (!super.equals(o)) {
                return false;
            }
            return Objects.equals(this.file, that.file) && (this.file != null || Objects.equals(this.textureId, that.textureId));
        }
    }
}

