/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.library;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.SkinNetworking;
import net.orifu.skin_overrides.library.AbstractLibrary;
import net.orifu.skin_overrides.util.TextureHelper;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public class CapeLibrary
extends AbstractLibrary {
    public static final CapeLibrary INSTANCE = new CapeLibrary();

    private CapeLibrary() {
        super("cape_overrides");
    }

    @Override
    protected Optional<Library.LibraryEntry> tryLoadFromJson(JsonObject object, String name, String id, @Nullable File file, @Nullable class_2960 textureId) {
        return Optional.of(new CapeEntry(name, id, file, textureId));
    }

    @Override
    protected void addDefaultEntries() {
        this.entries.add(new CapeEntry("skin overrides", "skin_overrides", Mod.id("cape.png")));
        SkinNetworking.getPlayerProfile().ifPresent(profile -> {
            for (SkinNetworking.PlayerProfileCape cape : profile.capes().reversed()) {
                Optional<Path> maybePath;
                TextureHelper.Builder texture = TextureHelper.cape().url(cape.url());
                Optional<class_2960> maybeId = texture.register();
                if (!maybeId.flatMap(arg_0 -> this.lambda$addDefaultEntries$1(maybePath = texture.path(), cape, arg_0)).isEmpty()) continue;
                Mod.LOGGER.error("error downloading cape");
            }
        });
    }

    public Optional<CapeEntry> create(String name, Path path) {
        return this.createInternal(name, null, path, null, null);
    }

    public Optional<CapeEntry> create(String name, class_2960 texture) {
        return this.createInternal(name, texture, null, null, null);
    }

    public Optional<CapeEntry> create(String name, class_1011 image) {
        return this.createInternal(name, null, null, image, null);
    }

    private Optional<CapeEntry> createInternal(String name, @Nullable class_2960 texture, @Nullable Path path, @Nullable class_1011 image, @Nullable String id) {
        if (id == null) {
            id = Util.randomId();
        }
        try {
            File file = new File(this.libraryFolder, id + ".png");
            if (path != null) {
                Files.copy(path, file.toPath(), new CopyOption[0]);
            } else if (texture != null) {
                Util.saveTexture(texture, 64, 32, file.toPath());
            } else {
                assert (image != null);
                Util.saveImage(image, file.toPath());
            }
            CapeEntry entry = new CapeEntry(name, id, file, texture);
            this.add(entry);
            return Optional.of(entry);
        }
        catch (IOException e) {
            Mod.LOGGER.error("failed to copy {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    private /* synthetic */ Optional lambda$addDefaultEntries$1(Optional maybePath, SkinNetworking.PlayerProfileCape cape, class_2960 id) {
        return maybePath.map(path -> this.createInternal(cape.alias(), id, (Path)path, null, cape.id()));
    }

    public static class CapeEntry
    extends AbstractLibrary.AbstractLibraryEntry {
        private final Supplier<class_2960> texture = Suppliers.memoize(() -> TextureHelper.cape().id("cape/library/" + this.fileHash).path(Objects.requireNonNull(this.file)).register().orElseGet(() -> {
            Mod.LOGGER.warn("cape library entry `{}` references a file that failed to load or doesn't exist: {}", (Object)this.getId(), (Object)this.file);
            return class_1060.field_5285;
        }));

        protected CapeEntry(String name, String id, @Nullable File file, @Nullable class_2960 textureId) {
            super(name, id, file, textureId);
        }

        protected CapeEntry(String name, String id, class_2960 textureId) {
            super(name, id, textureId);
        }

        @Override
        protected class_2960 getTextureFromFile() {
            return this.texture.get();
        }
    }
}

