/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.networking;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_7828;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.networking.ServerboundSkinUpdatePacket;
import net.orifu.skin_overrides.profile.FullProfile;
import org.jetbrains.annotations.Nullable;

public class ModNetworking {
    public static final String DEFAULT_TEXTURES_KEY = "skin_overrides-default_textures";
    private static boolean justJoinedServer = false;

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Mod.id("update_skin"), (srv, player, lstn, buf, sender) -> {
            Optional skinValue = buf.method_37436(class_2540::method_19772);
            Optional signature = buf.method_37436(class_2540::method_19772);
            class_3324 playerList = srv.method_3760();
            FullProfile profile = new FullProfile(player.method_7334());
            Mod.LOGGER.debug("received packet; {} changed skin:\nval: {}\nsig: {}", new Object[]{profile.name(), skinValue, signature});
            PropertyMap properties = profile.properties();
            if (!properties.containsKey((Object)DEFAULT_TEXTURES_KEY) && properties.containsKey((Object)"textures")) {
                Property defaultTextures = (Property)properties.get((Object)"textures").stream().findFirst().orElseThrow();
                properties.put((Object)DEFAULT_TEXTURES_KEY, (Object)new Property(DEFAULT_TEXTURES_KEY, ModNetworking.propValue(defaultTextures), ModNetworking.propSig(defaultTextures)));
            }
            properties.removeAll((Object)"textures");
            if (skinValue.isPresent() && signature.isPresent()) {
                Mod.LOGGER.debug("using new textures property");
                properties.put((Object)"textures", (Object)new Property("textures", (String)skinValue.get(), (String)signature.get()));
            } else {
                properties.get((Object)DEFAULT_TEXTURES_KEY).stream().findFirst().ifPresent(textures -> properties.put((Object)"textures", (Object)new Property("textures", ModNetworking.propValue(textures), ModNetworking.propSig(textures))));
            }
            Mod.LOGGER.debug("texture properties:\nprofile textures:                        {}\ndefault textures: {}", (Object)properties.get((Object)"textures"), (Object)properties.get((Object)DEFAULT_TEXTURES_KEY));
            for (class_3222 notifyPlayer : playerList.method_14571()) {
                if (notifyPlayer.equals((Object)player)) continue;
                notifyPlayer.field_13987.method_14364((class_2596)new class_7828(Collections.singletonList(player.method_5667())));
                notifyPlayer.field_13987.method_14364((class_2596)class_2703.method_43886(Collections.singleton(player)));
            }
            class_3218 level = player.method_51469();
            class_3898.class_3208 tracker = (class_3898.class_3208)level.method_14178().field_17254.field_18242.get(player.method_5628());
            if (tracker != null) {
                tracker.field_18250.forEach(listener -> tracker.field_18246.method_18760(listener.method_32311()));
            }
        });
    }

    private static String propValue(Property property) {
        return property.value();
    }

    @Nullable
    private static String propSig(Property property) {
        return property.signature();
    }

    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            justJoinedServer = true;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((listener, mc) -> {
            justJoinedServer = false;
        });
    }

    public static void onProfileLoad() {
        if (justJoinedServer) {
            justJoinedServer = false;
            Mod.SKINS.get(FullProfile.user()).ifPresent(ModNetworking::updateSkinOnServer);
        }
    }

    public static void updateSkinOnServer(@Nullable String skinValue, @Nullable String signature) {
        ModNetworking.updateSkinOnServer(() -> CompletableFuture.completedFuture(Optional.of(new Skin.Signature(skinValue, signature))));
    }

    public static void updateSkinOnServer(Skin.Signature.Provider signatureProvider) {
        if (ModNetworking.isOnSkinOverridesServer()) {
            Mod.LOGGER.debug("updating skin on server");
            signatureProvider.signature().thenAccept(sig -> {
                Mod.LOGGER.debug("received signature\n{}", sig);
                sig.ifPresent(ModNetworking::updateSkinOnServer);
            });
        }
    }

    private static void updateSkinOnServer(Skin.Signature sig) {
        Mod.LOGGER.debug("updating skin on server with signature:\n{}\n{}", (Object)sig.value(), (Object)sig.signature());
        class_2540 buf = PacketByteBufs.create();
        buf.method_37435(Optional.ofNullable(sig.value()), class_2540::method_10814);
        buf.method_37435(Optional.ofNullable(sig.signature()), class_2540::method_10814);
        ClientPlayNetworking.send((class_2960)Mod.id("update_skin"), (class_2540)buf);
    }

    public static void clearSkinOverrideOnServer() {
        ModNetworking.updateSkinOnServer(null, null);
        ModNetworking.removeUserNetworkOverride();
    }

    public static void removeUserNetworkOverride() {
        PropertyMap properties = FullProfile.user().properties();
        properties.get((Object)DEFAULT_TEXTURES_KEY).stream().findFirst().ifPresent(textures -> {
            properties.removeAll((Object)"textures");
            properties.put((Object)"textures", (Object)new Property("textures", ModNetworking.propValue(textures), ModNetworking.propSig(textures)));
        });
    }

    public static boolean isOnSkinOverridesServer() {
        return ClientPlayNetworking.canSend((class_2960)ServerboundSkinUpdatePacket.TYPE);
    }
}

