/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.library;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.library.AbstractLibrary;
import net.orifu.skin_overrides.networking.MineSkin;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.util.TextureHelper;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinLibrary
extends AbstractLibrary {
    public static final SkinLibrary INSTANCE = new SkinLibrary();

    private SkinLibrary() {
        super("skin_overrides");
    }

    @Override
    protected Optional<Library.LibraryEntry> tryLoadFromJson(JsonObject object, String name, String id, @Nullable File file, @Nullable class_2960 textureLoc) {
        Optional<String> model = Util.readString(object, "model");
        if (model.isPresent()) {
            Skin.Model skinModel = Skin.Model.parse(model.get());
            Skin.Signature signature = null;
            if (object.has("signed") && object.get("signed").isJsonObject()) {
                JsonObject signed = (JsonObject)object.get("signed");
                Optional<String> maybeSkinValue = Util.readString(signed, "value");
                Optional<String> maybeSkinSignature = Util.readString(signed, "signature");
                if (maybeSkinValue.isPresent() && maybeSkinSignature.isPresent()) {
                    signature = new Skin.Signature(maybeSkinValue.get(), maybeSkinSignature.get());
                }
            }
            return Optional.of(new SkinEntry(name, id, skinModel, file, textureLoc, signature));
        }
        return Optional.empty();
    }

    @Override
    protected void addDefaultEntries() {
        for (Skin playerSkin : Skin.defaultSkins()) {
            Object name = playerSkin.texture().method_12832();
            name = ((String)name).substring(((String)name).lastIndexOf(47) + 1);
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1).replace(".png", "");
            name = (String)name + (playerSkin.model().equals((Object)Skin.Model.WIDE) ? " (wide)" : " (slim)");
            this.entries.add(new SkinEntry((String)name, Util.seededId((String)name), playerSkin.model(), playerSkin.texture()));
        }
    }

    public Optional<SkinEntry> create(String name, Path path, Skin.Model model) {
        return this.createInternal(name, model, null, path, null, null);
    }

    public Optional<SkinEntry> create(String name, class_2960 texture, Skin.Model model) {
        return this.createInternal(name, model, texture, null, null, null);
    }

    public Optional<SkinEntry> createSigned(String name, class_2960 texture, Skin.Model model, FullProfile profile) {
        Optional property = profile.properties().get((Object)"textures").stream().findAny();
        return property.flatMap(Skin.Signature::fromProperty).flatMap(sig -> this.createInternal(name, model, texture, null, null, (Skin.Signature)sig));
    }

    public Optional<SkinEntry> createSigned(String name, class_1011 image, Skin.Model model, FullProfile profile) {
        Optional property = profile.properties().get((Object)"textures").stream().findAny();
        return property.flatMap(Skin.Signature::fromProperty).flatMap(sig -> this.createInternal(name, model, null, null, image, (Skin.Signature)sig));
    }

    private Optional<SkinEntry> createInternal(String name, Skin.Model model, class_2960 texture, Path path, class_1011 image, Skin.Signature signature) {
        try {
            String id = Util.randomId();
            File file = new File(this.libraryFolder, id + ".png");
            if (path != null) {
                Files.copy(path, file.toPath(), new CopyOption[0]);
            } else if (texture != null) {
                Util.saveTexture(texture, 64, 64, file.toPath());
            } else {
                Util.saveImage(image, file.toPath());
            }
            SkinEntry entry = new SkinEntry(name, id, model, file, texture, signature);
            this.add(entry);
            return Optional.of(entry);
        }
        catch (IOException e) {
            Mod.LOGGER.error("failed to copy {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    public static class SkinEntry
    extends AbstractLibrary.AbstractLibraryEntry {
        protected final Skin.Model model;
        @Nullable
        public final Skin.Signature signature;
        private final Supplier<class_2960> texture = Suppliers.memoize(() -> TextureHelper.skin().location("skin/library/" + this.fileHash).path(this.file).register().orElseThrow());
        @Nullable
        private CompletableFuture<Optional<SkinEntry>> signedCache = null;

        protected SkinEntry(String name, String id, Skin.Model model, @Nullable File file, @Nullable class_2960 textureLoc, @Nullable Skin.Signature signature) {
            super(name, id, file, textureLoc);
            this.model = model;
            this.signature = signature;
        }

        protected SkinEntry(String name, String id, Skin.Model model, @NotNull File file, Skin.Signature signature) {
            this(name, id, model, file, null, signature);
        }

        protected SkinEntry(String name, String id, Skin.Model model, @NotNull class_2960 textureLoc) {
            this(name, id, model, null, textureLoc, null);
        }

        @Override
        protected class_2960 getTextureFromFile() {
            return this.texture.get();
        }

        public Skin toSkin() {
            return new Skin(this.getTexture(), null, null, this.getModel());
        }

        public Skin.Model getModel() {
            return this.model;
        }

        @Override
        public JsonElement toJson() {
            JsonObject obj = super.toJson().getAsJsonObject();
            obj.addProperty("model", this.model.id());
            if (this.signature != null) {
                JsonObject signedSkin = new JsonObject();
                signedSkin.addProperty("value", this.signature.value());
                signedSkin.addProperty("signature", this.signature.signature());
                obj.add("signed", (JsonElement)signedSkin);
            }
            return obj;
        }

        public CompletableFuture<Optional<SkinEntry>> signed() {
            if (this.signature != null) {
                return CompletableFuture.completedFuture(Optional.of(this));
            }
            if (this.signedCache != null) {
                return this.signedCache;
            }
            CompletableFuture<Optional<Skin.Signature>> signature = MineSkin.sign(this.getTexture(), this.model);
            this.signedCache = signature.thenApply(maybeSig -> maybeSig.map(sig -> new SkinEntry(this.name, this.id, this.model, this.file, this.textureLoc, (Skin.Signature)sig)));
            return this.signedCache;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SkinEntry)) {
                return false;
            }
            SkinEntry skinEntry = (SkinEntry)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.model == skinEntry.model;
        }
    }
}

