/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.profile.PartialProfile;
import net.orifu.skin_overrides.profile.Profile;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class OverrideManager {
    public final boolean skin;
    private final File dir;
    private final Library library;
    private final List<Overrider> overriders = new ArrayList<Overrider>();
    private final Map<String, Overridden> overrides = new HashMap<String, Overridden>();

    public OverrideManager(boolean skin, String directory, Library library, Overrider ... overriders) {
        this.skin = skin;
        this.dir = new File(directory);
        this.library = library;
        this.overriders.add(library.overrider());
        this.overriders.addAll(List.of(overriders));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        HashMap newOverrides = new HashMap();
        this.findOverrides(ov -> {
            String key;
            Overridden maybeExisting = this.overrides.get(key = ov.override.playerIdent().toLowerCase(Locale.ROOT));
            newOverrides.put(key, ov.equals(maybeExisting) ? maybeExisting : ov);
        });
        Map<String, Overridden> map = this.overrides;
        synchronized (map) {
            Optional<Override> oldUserOverride = this.get(FullProfile.user());
            this.overrides.clear();
            this.overrides.putAll(newOverrides);
            Optional<Override> newUserOverride = this.get(FullProfile.user());
            if (!oldUserOverride.equals(newUserOverride)) {
                CompletableFuture.runAsync(() -> Mod.onUserOverrideUpdate(oldUserOverride.orElse(null), newUserOverride.orElse(null)));
            }
        }
    }

    public void removeOverride(Profile profile) {
        this.getData(profile).ifPresent(data -> {
            if (!data.file.delete()) {
                Mod.LOGGER.debug("failed to delete override file {} for {}", (Object)data.file, (Object)data.override.playerIdent());
            }
            this.update();
        });
    }

    private void findOverrides(Consumer<Overridden> handler) {
        if (this.dir.mkdir()) {
            Mod.LOGGER.debug("created folder for overrides");
        }
        block0: for (File file : Objects.requireNonNull(this.dir.listFiles())) {
            String name = FilenameUtils.getBaseName((String)file.getName());
            String ext = FilenameUtils.getExtension((String)file.getName());
            for (Overrider overrider : this.overriders) {
                Optional<Override> override = overrider.get(file, name, ext);
                if (!override.isPresent()) continue;
                handler.accept(new Overridden(file, override.get()));
                continue block0;
            }
        }
    }

    public Library library() {
        return this.library;
    }

    public synchronized Optional<Override> get(Profile profile) {
        return this.getData(profile).map(Overridden::override);
    }

    public synchronized Optional<Override> get(String ident) {
        return this.getData(ident).map(Overridden::override);
    }

    private synchronized Optional<Overridden> getData(Profile profile) {
        return this.getData(profile.name()).or(() -> this.getData(profile.uuid().toString()));
    }

    private synchronized Optional<Overridden> getData(String ident) {
        return Optional.ofNullable(this.overrides.get(ident.toLowerCase(Locale.ROOT)));
    }

    public synchronized boolean has(Profile profile) {
        return this.get(profile).isPresent();
    }

    public void addOverride(Profile profile, Library.LibraryEntry entry) {
        this.removeOverride(profile);
        this.library.overrider().addOverride(profile, entry);
    }

    public void copyOverride(Profile profile, Path path, @Nullable Skin.Model model) {
        this.removeOverride(profile);
        String ext = FilenameUtils.getExtension((String)path.toString());
        for (Overrider overrider : this.overriders) {
            String fileName = overrider.fileName(profile, model);
            if (!FilenameUtils.getExtension((String)fileName).equals(ext)) continue;
            try {
                Path outputPath = new File(this.dir, fileName).toPath();
                Files.copy(path, outputPath, new CopyOption[0]);
            }
            catch (IOException e) {
                Mod.LOGGER.error("failed to copy {}", (Object)path, (Object)e);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletableFuture<PartialProfile>> profilesWithOverride() {
        Map<String, Overridden> map = this.overrides;
        synchronized (map) {
            return this.overrides.keySet().stream().map(PartialProfile::resolve).toList();
        }
    }

    public static interface Overrider {
        public String fileName(Profile var1, @Nullable Skin.Model var2);

        public Optional<Override> get(File var1, String var2, String var3);
    }

    public record Overridden(File file, Override override) {
    }

    public static interface Override
    extends Skin.Signature.Provider {
        public String playerIdent();

        @Nullable
        public class_2960 texture();

        @Nullable
        public File texturePath();

        public class_2561 info();

        @Nullable
        default public Skin.Model model() {
            return null;
        }

        @java.lang.Override
        default public CompletableFuture<Optional<Skin.Signature>> signature() {
            return CompletableFuture.completedFuture(Optional.empty());
        }
    }
}

