/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.gui.components;

import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.gui.components.LibraryListEntry;
import net.orifu.skin_overrides.gui.components.ObjectSelectionGrid;
import net.orifu.skin_overrides.gui.screen.LibraryScreen;

public class LibrarySelectionGrid
extends ObjectSelectionGrid<LibraryListEntry> {
    private final LibraryScreen parent;
    private final OverrideManager ov;
    private final ArrayList<LibraryListEntry> allEntries = new ArrayList();
    @Nullable
    private Library.LibraryEntry lastSelected = null;
    private String query = "";

    public LibrarySelectionGrid(LibraryScreen parent, OverrideManager ov) {
        super(class_310.method_1551(), 0, 0, 0, 70, 79, 6);
        this.parent = parent;
        this.ov = ov;
        this.reload();
    }

    public int indexOf(LibraryListEntry entry) {
        return this.method_25396().indexOf((Object)entry);
    }

    public void reload() {
        this.ov.library().reload();
        int i = 0;
        for (Library.LibraryEntry entry : this.ov.library().entries()) {
            boolean add = true;
            for (LibraryListEntry child : this.allEntries) {
                if (!child.entry.getId().equals(entry.getId())) continue;
                add = false;
                child.entry = entry;
                child.index = i++;
                break;
            }
            if (!add) continue;
            this.allEntries.add(new LibraryListEntry(entry, i++, this.parent));
        }
        this.allEntries.sort(Comparator.comparingInt(e -> e.index));
        this.filter(this.query);
    }

    public void removeFromLibrary() {
        if (this.method_25334() == null) {
            return;
        }
        int index = ((LibraryListEntry)this.method_25334()).index;
        int childIndex = this.indexOf((LibraryListEntry)this.method_25334());
        int newIndex = childIndex == this.method_25396().size() - 1 ? childIndex - 1 : childIndex;
        this.allEntries.remove(index);
        this.ov.library().remove(index);
        this.reload();
        LibraryListEntry newEntry = newIndex >= 0 ? (LibraryListEntry)this.method_25326(newIndex) : null;
        this.method_25313((class_350.class_351)newEntry);
        this.parent.selectEntry(newEntry);
    }

    public void move(int i, int j) {
        this.ov.library().move(((LibraryListEntry)((Object)this.method_25396().get((int)i))).index, ((LibraryListEntry)((Object)this.method_25396().get((int)j))).index);
        this.reload();
    }

    public void moveSelection(int amount) {
        if (this.method_25334() == null) {
            return;
        }
        LibraryListEntry newSelected = (LibraryListEntry)this.method_25326(this.indexOf((LibraryListEntry)this.method_25334()) + amount);
        this.method_25313((class_350.class_351)newSelected);
        this.parent.selectEntry(newSelected);
    }

    public void filter(String query) {
        this.query = query.toLowerCase();
        LibraryListEntry selected = (LibraryListEntry)this.method_25334();
        if (selected != null) {
            this.lastSelected = selected.entry;
        }
        this.method_25339();
        for (LibraryListEntry entry : this.allEntries) {
            if (!entry.entry.getName().toLowerCase().contains(this.query)) continue;
            this.method_25321((class_350.class_351)entry);
            if (!entry.entry.equals(this.lastSelected)) continue;
            this.method_25313((class_350.class_351)entry);
        }
    }

    @Override
    protected int xTiles() {
        return Math.max(this.field_22758 / this.itemWidth, 1);
    }

    public int method_25322() {
        return this.xTiles() * this.itemWidth;
    }

    @Override
    protected int scrollBarX() {
        return this.method_55442() - 6;
    }
}

