/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.library.CapeLibrary;
import net.orifu.skin_overrides.library.SkinLibrary;
import net.orifu.skin_overrides.networking.ModNetworking;
import net.orifu.skin_overrides.override.LocalCapeOverrider;
import net.orifu.skin_overrides.override.LocalSkinOverrider;
import net.orifu.skin_overrides.override.SkinChangeOverride;
import net.orifu.skin_overrides.override.SkinCopyOverrider;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.profile.Profile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mod {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"skin overrides");
    public static final String MOD_ID = "skin_overrides";
    public static final String MOD_VERSION = "2.4.0-beta.2";
    public static final String SKIN_OVERRIDES_PATH = "skin_overrides";
    public static final String CAPE_OVERRIDES_PATH = "cape_overrides";
    public static final OverrideManager SKINS = new OverrideManager(true, "skin_overrides", SkinLibrary.INSTANCE, new LocalSkinOverrider(), new SkinCopyOverrider());
    public static final OverrideManager CAPES = new OverrideManager(false, "cape_overrides", CapeLibrary.INSTANCE, new LocalCapeOverrider());

    public static class_2960 res(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static class_2960 res(String path) {
        return Mod.res("skin_overrides", path);
    }

    public static class_2960 defaultId(String path) {
        return Mod.res("minecraft", path);
    }

    public static Skin override(FullProfile profile) {
        return Mod.override(profile, Skin.fromProfile(profile));
    }

    public static Skin override(FullProfile profile, Skin skin) {
        Optional<class_3545<class_2960, Skin.Model>> ovSkin;
        if (profile.isOffline() && profile.name().equals(FullProfile.user().name())) {
            profile = FullProfile.user();
            skin = Skin.fromProfile(profile);
        }
        if ((ovSkin = Mod.overrideSkin(profile)).isPresent()) {
            skin = skin.withSkin((class_2960)ovSkin.get().method_15442(), (Skin.Model)((Object)ovSkin.get().method_15441()));
        }
        skin = skin.withCape(Mod.overrideCapeOrDefault(profile));
        return skin;
    }

    public static Skin overrideProfile(Profile profile) {
        Skin skin;
        if (profile instanceof FullProfile) {
            FullProfile f = (FullProfile)profile;
            skin = Mod.override(f);
        } else {
            skin = Mod.overridePartial(profile);
        }
        return skin;
    }

    public static Skin overridePartial(Profile profile) {
        return Mod.overridePartial(profile, null);
    }

    public static Skin overridePartial(Profile profile, @Nullable Skin skin) {
        Optional<class_3545<class_2960, Skin.Model>> ovSkin = Mod.overrideSkin(profile);
        Optional<class_2960> ovCape = Mod.overrideCape(profile);
        Skin defaultSkin = skin != null ? skin : profile.defaultSkin();
        return new Skin(ovSkin.map(class_3545::method_15442).orElse(defaultSkin.texture()), ovCape.orElse(null), ovCape.orElse(null), ovSkin.map(class_3545::method_15441).orElse(defaultSkin.model()));
    }

    public static Optional<class_3545<class_2960, Skin.Model>> overrideSkin(Profile profile) {
        return SKINS.get(profile).filter(ov -> ov.texture() != null).map(ov -> new class_3545((Object)ov.texture(), (Object)ov.model())).or(() -> SkinChangeOverride.texture(profile));
    }

    public static Optional<class_2960> overrideCape(Profile profile) {
        return CAPES.get(profile).map(OverrideManager.Override::texture);
    }

    public static class_2960 overrideCapeOrDefault(FullProfile profile) {
        return Mod.overrideCape(profile).orElseGet(() -> Skin.fromProfile(profile).withDefaultCape(profile).capeTexture());
    }

    public static void onUserOverrideUpdate(@Nullable OverrideManager.Override oldOverride, @Nullable OverrideManager.Override newOverride) {
        if (newOverride != null) {
            ModNetworking.updateSkinOnServer(newOverride);
        } else if (oldOverride != null) {
            ModNetworking.clearSkinOverrideOnServer();
        }
    }
}

