/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.orifu.skin_overrides.profile.FullProfile;
import net.orifu.skin_overrides.util.TextureHelper;
import org.jetbrains.annotations.Nullable;

public record Skin(class_2960 texture, @Nullable class_2960 capeTexture, @Nullable class_2960 elytraTexture, Model model) {
    public static final Skin DEFAULT_SKIN = new Skin();

    public Skin() {
        this(Skin.defaultSkinTexture(), null, null, Model.WIDE);
    }

    public static Skin fromProfile(FullProfile profile) {
        class_1071 manager = class_310.method_1551().method_1582();
        Map textures = manager.method_4654(profile.game());
        MinecraftProfileTexture skin = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
        MinecraftProfileTexture cape = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.CAPE);
        MinecraftProfileTexture elytra = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.ELYTRA);
        class_2960 skinId = skin != null ? manager.method_4656(skin, MinecraftProfileTexture.Type.SKIN) : class_1068.method_4648((UUID)profile.uuid());
        return new Skin(skinId, cape != null ? manager.method_4656(cape, MinecraftProfileTexture.Type.CAPE) : null, elytra != null ? manager.method_4656(elytra, MinecraftProfileTexture.Type.ELYTRA) : null, skin != null ? Model.parse(skin.getMetadata("model")) : Model.parse(class_1068.method_4647((UUID)profile.uuid())));
    }

    public static class_2960 defaultSkinTexture() {
        return class_1068.method_4649();
    }

    public static Skin[] defaultSkins() {
        ArrayList<Skin> skins = new ArrayList<Skin>();
        for (class_1068.class_7921 skin : class_1068.field_41121) {
            skins.add(new Skin(skin.comp_1154(), null, null, skin.comp_1155().equals((Object)class_1068.class_7920.field_41123) ? Model.WIDE : Model.SLIM));
        }
        return (Skin[])skins.toArray(Skin[]::new);
    }

    public static CompletableFuture<Optional<DownloadResult>> download(FullProfile profile, boolean skin) {
        return CompletableFuture.supplyAsync(() -> {
            Map textures = class_310.method_1551().method_1495().getTextures(profile.game(), false);
            MinecraftProfileTexture mcTexture = (MinecraftProfileTexture)textures.get(skin ? MinecraftProfileTexture.Type.SKIN : MinecraftProfileTexture.Type.CAPE);
            if (mcTexture == null) {
                return Optional.empty();
            }
            Optional<class_1011> image = TextureHelper.skin().url(mcTexture.getUrl()).image();
            Model model = Model.parse(mcTexture.getMetadata("model"));
            return image.map(img -> new DownloadResult((class_1011)img, model));
        });
    }

    public static CompletableFuture<Skin> fetchSkin(FullProfile profile) {
        class_1071 manager = class_310.method_1551().method_1582();
        CompletableFuture<Skin> future = new CompletableFuture<Skin>();
        manager.method_4652(profile.game(), (ty, id, tx) -> {
            if (ty.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                future.complete(new Skin(id, null, null, Model.parse(tx.getMetadata("model"))));
            }
        }, false);
        return future;
    }

    public Skin withSkin(class_2960 skin, Model model) {
        return new Skin(skin, this.capeTexture, this.elytraTexture, model);
    }

    public Skin withCape(@Nullable class_2960 cape) {
        return new Skin(this.texture, cape, null, this.model);
    }

    public Skin withDefaultCape(FullProfile profile) {
        if (profile.properties().containsKey((Object)"skin_overrides-default_textures")) {
            class_1071 manager = class_310.method_1551().method_1582();
            Property property = (Property)profile.properties().get((Object)"skin_overrides-default_textures").stream().findFirst().orElseThrow();
            Map textures = (Map)manager.field_5306.getUnchecked((Object)property.getValue());
            MinecraftProfileTexture capeTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.CAPE);
            class_2960 textureId = capeTexture != null ? manager.method_4656(capeTexture, MinecraftProfileTexture.Type.CAPE) : null;
            return this.withCape(textureId);
        }
        return this;
    }

    public static enum Model {
        WIDE("wide", "classic"),
        SLIM("slim");

        private final String key;
        public final String apiName;

        private Model(String key) {
            this(key, key);
        }

        private Model(String key, String apiName) {
            this.key = key;
            this.apiName = apiName;
        }

        public static Model parse(@Nullable String key) {
            Model model = Model.tryParse(key);
            return model == null ? WIDE : model;
        }

        @Nullable
        public static Model tryParse(@Nullable String key) {
            if (key == null) {
                return null;
            }
            if ((key = key.toLowerCase(Locale.ROOT)).equals(Model.WIDE.key) || key.equals(Model.WIDE.apiName)) {
                return WIDE;
            }
            if (key.equals(Model.SLIM.key) || key.equals(Model.SLIM.apiName)) {
                return SLIM;
            }
            return null;
        }

        public String id() {
            return this.key;
        }
    }

    public record DownloadResult(class_1011 image, Model model) {
    }

    public record Signature(@Nullable String value, @Nullable String signature) {
        public static Optional<Signature> fromProperty(Property property) {
            return property.getSignature() != null ? Optional.of(new Signature(property.getValue(), property.getSignature())) : Optional.empty();
        }

        public static interface Provider {
            public CompletableFuture<Optional<Signature>> signature();
        }
    }
}

